/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.parse.expr.EvalException;

final class MethodUtil {
    private MethodUtil() {
    }

    public static Object invokeRefreshed(Method method, Object target, Object ... params) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(MethodUtil.refresh(target), params);
    }

    public static Object refresh(Object obj) {
        return obj instanceof JObject ? MethodUtil.refresh((JObject)obj) : obj;
    }

    public static JObject refresh(JObject jobj) {
        return !jobj.getTransaction().isValid() ? JTransaction.getCurrent().get(jobj) : jobj;
    }

    public static Method findMatchingMethod(Class<?> type, String name, boolean searchNonPublic, Type[] paramTypes, Class<?> returnType, boolean isStatic) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : type.getMethods()) {
            if ((method.getModifiers() & 8) != 0 != isStatic) continue;
            methods.add(method);
        }
        ArrayList candidates = MethodUtil.findCandidates(type, methods, name, paramTypes, returnType);
        if (candidates.isEmpty() && searchNonPublic) {
            methods.clear();
            for (Class<?> superType = type; superType != null; superType = superType.getSuperclass()) {
                for (Method method : superType.getDeclaredMethods()) {
                    if ((method.getModifiers() & 1) != 0 || (method.getModifiers() & 8) != 0 != isStatic) continue;
                    methods.add(method);
                }
            }
            candidates.addAll(MethodUtil.findCandidates(type, methods, name, paramTypes, returnType));
        }
        Method method = (Method)MethodUtil.selectBestCandidate(candidates, type, name, (isStatic ? "static" : "instance") + " method");
        try {
            return MethodUtil.makeAccessible(method);
        }
        catch (IllegalArgumentException e) {
            throw new EvalException(e.getMessage());
        }
    }

    public static Constructor<?> findMatchingConstructor(Class<?> type, Type[] paramTypes) {
        ArrayList<Constructor<?>> candidates = MethodUtil.findCandidates(type, Arrays.asList(type.getConstructors()), type.getName(), paramTypes, null);
        return MethodUtil.selectBestCandidate(candidates, type, type.getSimpleName(), "constructor");
    }

    private static <T extends Executable> ArrayList<T> findCandidates(Class<?> type, Iterable<? extends T> executables, String name, Type[] paramTypes, Class<?> returnType) {
        ArrayList<Executable> candidates = new ArrayList<Executable>(3);
        block0: for (Executable executable : executables) {
            if (name != null && !executable.getName().equals(name) || returnType != null && !MethodUtil.isCompatible(returnType, ((Method)executable).getReturnType())) continue;
            Class<?>[] mparamTypes = executable.getParameterTypes();
            if (!executable.isVarArgs() ? mparamTypes.length != paramTypes.length : mparamTypes.length > paramTypes.length + 1) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (executable.isVarArgs() && i >= mparamTypes.length - 1) {
                    Class<?> lastParamType = mparamTypes[mparamTypes.length - 1];
                    if (paramTypes.length == mparamTypes.length && MethodUtil.isCompatibleMethodParam(mparamTypes[i], paramTypes[i])) continue;
                    assert (lastParamType.isArray());
                    if (!MethodUtil.isCompatibleMethodParam(lastParamType.getComponentType(), paramTypes[i])) continue block0;
                    continue;
                }
                if (!MethodUtil.isCompatibleMethodParam(mparamTypes[i], paramTypes[i])) continue block0;
            }
            candidates.add(executable);
        }
        return candidates;
    }

    private static <T extends Executable> T selectBestCandidate(ArrayList<? extends T> candidates, Class<?> type, String name, String description) {
        if (candidates.isEmpty()) {
            throw new EvalException("no compatible " + description + " `" + name + "()' found in " + type);
        }
        try {
            Collections.sort(candidates, new SignatureComparator());
        }
        catch (IllegalArgumentException e) {
            throw new EvalException("ambiguous invocation of `" + name + "()' in " + type);
        }
        return (T)((Executable)candidates.get(0));
    }

    public static boolean isCompatibleMethodParam(Class<?> to, Type from) {
        if (from == FunctionalType.class) {
            try {
                MethodUtil.findFunctionalMethod(to);
            }
            catch (EvalException e) {
                return false;
            }
            return true;
        }
        if (from == NullType.class) {
            return !to.isPrimitive();
        }
        if (from instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)from).getBounds()) {
                if (TypeToken.of((Type)bound).isSupertypeOf(TypeToken.of(to).wrap())) continue;
                return false;
            }
            return true;
        }
        return MethodUtil.isCompatible(to, TypeToken.of((Type)from).getRawType());
    }

    public static boolean isCompatible(Class<?> to, Class<?> from) {
        if (to.isPrimitive()) {
            if (!(from = TypeToken.of(from).unwrap().getRawType()).isPrimitive()) {
                return false;
            }
            return MethodUtil.isCompatiblePrimitive(to, from);
        }
        if (from.isPrimitive()) {
            from = TypeToken.of(from).wrap().getRawType();
        }
        return to.isAssignableFrom(from);
    }

    public static boolean isCompatiblePrimitive(Class<?> to, Class<?> from) {
        assert (to.isPrimitive());
        assert (from.isPrimitive());
        if (to == from) {
            return true;
        }
        if (to == Integer.TYPE) {
            return from.equals(Byte.TYPE) || from.equals(Character.TYPE) || from.equals(Short.TYPE);
        }
        if (to == Float.TYPE || to == Long.TYPE) {
            return from.equals(Byte.TYPE) || from.equals(Character.TYPE) || from.equals(Short.TYPE) || from.equals(Integer.TYPE);
        }
        if (to == Double.TYPE) {
            return from.equals(Byte.TYPE) || from.equals(Character.TYPE) || from.equals(Short.TYPE) || from.equals(Integer.TYPE) || from.equals(Float.TYPE) || from.equals(Long.TYPE);
        }
        return false;
    }

    public static Method findFunctionalMethod(Class<?> type) {
        if (!type.isInterface()) {
            throw new EvalException(type + " is not an interface type");
        }
        Method functionalMethod = null;
        for (Method method : type.getMethods()) {
            if ((method.getModifiers() & 0x400) == 0 || MethodUtil.isPublicObjectMethod(method)) continue;
            if (functionalMethod != null) {
                functionalMethod = null;
                break;
            }
            functionalMethod = method;
        }
        if (functionalMethod == null) {
            throw new EvalException(type + " is not a functional type");
        }
        return functionalMethod;
    }

    static Method makeAccessible(Method method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"null method");
        Class<?> cl = method.getDeclaringClass();
        do {
            if ((cl.getModifiers() & 1) != 0) {
                try {
                    return cl.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            for (Class<?> iface : cl.getInterfaces()) {
                try {
                    return iface.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                }
            }
        } while ((cl = cl.getSuperclass()) != null);
        method.setAccessible(true);
        return method;
    }

    static boolean isPublicObjectMethod(Method method) {
        Method objMethod;
        try {
            objMethod = Object.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return (objMethod.getModifiers() & 1) != 0;
    }

    private static class SignatureComparator
    implements Comparator<Executable>,
    Serializable {
        private static final long serialVersionUID = 1169904024798638618L;

        private SignatureComparator() {
        }

        @Override
        public int compare(Executable m1, Executable m2) {
            Class<?>[] types2;
            Class<?>[] types1 = m1.getParameterTypes();
            if (types1.length != (types2 = m2.getParameterTypes()).length) {
                throw new IllegalArgumentException();
            }
            boolean m1wide = true;
            boolean m2wide = true;
            for (int i = 0; i < types1.length; ++i) {
                if (!MethodUtil.isCompatibleMethodParam(types1[i], types2[i])) {
                    m1wide = false;
                }
                if (MethodUtil.isCompatibleMethodParam(types2[i], types1[i])) continue;
                m2wide = false;
            }
            if (m1wide && m2wide) {
                if (m1 instanceof Method && m2 instanceof Method) {
                    Class<?> rtype1 = ((Method)m1).getReturnType();
                    Class<?> rtype2 = ((Method)m2).getReturnType();
                    boolean r1narrow = rtype2.isAssignableFrom(rtype1);
                    boolean r2narrow = rtype1.isAssignableFrom(rtype2);
                    if (r1narrow && !r2narrow) {
                        return -1;
                    }
                    if (!r1narrow && r2narrow) {
                        return 1;
                    }
                }
                return 0;
            }
            if (m1wide && !m2wide) {
                return 1;
            }
            if (!m1wide && m2wide) {
                return -1;
            }
            throw new IllegalArgumentException();
        }
    }

    public static final class FunctionalType {
        private FunctionalType() {
        }
    }

    public static final class NullType {
        private NullType() {
        }
    }
}

