/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractLValue;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Value;

public enum Op {
    ARRAY_ACCESS(2, "[]"){

        @Override
        Value apply(ParseSession session, Value targetValue, Value itemValue) {
            final Object target = targetValue.checkNotNull(session, "array access");
            if (target instanceof Map) {
                final Map map = (Map)target;
                final Object key = targetValue.get(session);
                return new AbstractLValue(){

                    @Override
                    public Object get(ParseSession session) {
                        return map.get(key);
                    }

                    @Override
                    public void set(ParseSession session, Value value) {
                        Object obj = value.get(session);
                        try {
                            map.put(key, obj);
                        }
                        catch (RuntimeException e) {
                            throw new EvalException("invalid map put operation" + (e.getMessage() != null ? ": " + e.getMessage() : ""), e);
                        }
                    }
                };
            }
            if (target instanceof List) {
                final List list = (List)target;
                final int index = itemValue.checkIntegral(session, "list index");
                return new AbstractLValue(){

                    @Override
                    public Object get(ParseSession session) {
                        return list.get(index);
                    }

                    @Override
                    public void set(ParseSession session, Value value) {
                        Object obj = value.get(session);
                        try {
                            list.set(index, obj);
                        }
                        catch (RuntimeException e) {
                            throw new EvalException("invalid list set operation" + (e.getMessage() != null ? ": " + e.getMessage() : ""), e);
                        }
                    }
                };
            }
            final int index = itemValue.checkIntegral(session, "array index");
            return new AbstractLValue(){

                @Override
                public Object get(ParseSession session) {
                    try {
                        return Array.get(target, index);
                    }
                    catch (IllegalArgumentException e) {
                        throw new EvalException("invalid array access operation on non-array of type `" + target.getClass().getName() + "'", e);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new EvalException("array index out of bounds" + (e.getMessage() != null ? ": " + e.getMessage() : ""), e);
                    }
                }

                @Override
                public void set(ParseSession session, Value value) {
                    Object obj = value.get(session);
                    try {
                        Array.set(target, index, obj);
                    }
                    catch (IllegalArgumentException e) {
                        throw new EvalException("invalid array set operation" + (e.getMessage() != null ? ": " + e.getMessage() : ""), e);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new EvalException("array index out of bounds" + (e.getMessage() != null ? ": " + e.getMessage() : ""), e);
                    }
                }
            };
        }
    }
    ,
    MEMBER_ACCESS(2, "."),
    INVOKE_METHOD(2, "()"),
    POST_INCREMENT(1, "++"),
    POST_DECREMENT(1, "--"),
    PRE_INCREMENT(1, "++"),
    PRE_DECREMENT(1, "--"),
    UNARY_PLUS(1, "+"){

        @Override
        Value apply(ParseSession session, Value value) {
            return new ConstValue(value.checkNumeric(session, "unary plus"));
        }
    }
    ,
    UNARY_MINUS(1, "-"){

        @Override
        Value apply(ParseSession session, Value value) {
            return value.negate(session);
        }
    }
    ,
    LOGICAL_NOT(1, "!"){

        @Override
        Value apply(ParseSession session, Value value) {
            return new ConstValue(!value.checkBoolean(session, "logical `not'"));
        }
    }
    ,
    INVERT(1, "~"){

        @Override
        Value apply(ParseSession session, Value value) {
            return value.invert(session);
        }
    }
    ,
    CAST(1, "()"){}
    ,
    MULTIPLY(2, "*"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.multiply(session, rhs);
        }
    }
    ,
    DIVIDE(2, "/"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.divide(session, rhs);
        }
    }
    ,
    MODULO(2, "%"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.mod(session, rhs);
        }
    }
    ,
    PLUS(2, "+"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.add(session, rhs);
        }
    }
    ,
    MINUS(2, "-"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.subtract(session, rhs);
        }
    }
    ,
    LSHIFT(2, "<<"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.lshift(session, rhs);
        }
    }
    ,
    RSHIFT(2, ">>"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.rshift(session, rhs);
        }
    }
    ,
    URSHIFT(2, ">>>"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.urshift(session, rhs);
        }
    }
    ,
    LT(2, "<"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.compare(session, rhs, 1);
        }
    }
    ,
    GT(2, ">"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.compare(session, rhs, 2);
        }
    }
    ,
    LTEQ(2, "<="){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.compare(session, rhs, 5);
        }
    }
    ,
    GTEQ(2, ">="){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.compare(session, rhs, 6);
        }
    }
    ,
    INSTANCEOF(2, "instanceof"){}
    ,
    EQUAL(2, "=="){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            Object lval = lhs.get(session);
            Object rval = rhs.get(session);
            if (lval == null || rval == null) {
                return new ConstValue(lval == rval);
            }
            if (lval instanceof Number || rval instanceof Number) {
                return lhs.compare(session, rhs, 4);
            }
            return new ConstValue(lval.equals(rval));
        }
    }
    ,
    NOT_EQUAL(2, "!="){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return new ConstValue((Boolean)EQUAL.apply(session, lhs, rhs).get(session) == false);
        }
    }
    ,
    AND(2, "&"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.and(session, rhs);
        }
    }
    ,
    OR(2, "|"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.or(session, rhs);
        }
    }
    ,
    XOR(2, "^"){

        @Override
        Value apply(ParseSession session, Value lhs, Value rhs) {
            return lhs.xor(session, rhs);
        }
    }
    ,
    LOGICAL_AND(2, "&&"),
    LOGICAL_OR(2, "||"),
    CONDITIONAL(3, "?:"),
    EQUALS(2, "="),
    PLUS_EQUALS(2, "+="),
    MINUS_EQUALS(2, "-="),
    MULTIPLY_EQUALS(2, "*="),
    DIVIDE_EQUALS(2, "/="),
    MODULO_EQUALS(2, "%="),
    AND_EQUALS(2, "&="),
    XOR_EQUALS(2, "^="),
    OR_EQUALS(2, "|="),
    LSHIFT_EQUALS(2, "<<="),
    RSHIFT_EQUALS(2, ">>="),
    URSHIFT_EQUALS(2, ">>>=");

    private final int arity;
    private final String symbol;

    private Op(int arity, String symbol) {
        this.arity = arity;
        this.symbol = symbol;
    }

    public int getArity() {
        return this.arity;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Value apply(ParseSession session, Value ... args) {
        if (args.length != this.arity) {
            throw new EvalException("wrong number of arguments " + args.length + " != " + this.arity + " given to " + (Object)((Object)this));
        }
        switch (args.length) {
            case 1: {
                return this.apply(session, args[0]);
            }
            case 2: {
                return this.apply(session, args[0], args[1]);
            }
            case 3: {
                return this.apply(session, args[0], args[1], args[2]);
            }
        }
        throw new RuntimeException("internal error");
    }

    public static Op forSymbol(String symbol) {
        switch (symbol) {
            case "+": {
                return PLUS;
            }
            case "-": {
                return MINUS;
            }
            case "++": {
                return POST_INCREMENT;
            }
            case "--": {
                return POST_DECREMENT;
            }
        }
        for (Op op : Op.values()) {
            if (!op.symbol.equals(symbol)) continue;
            return op;
        }
        throw new IllegalArgumentException("no operation with symbol `" + symbol + "' exists");
    }

    Value apply(ParseSession session, Value arg) {
        throw new UnsupportedOperationException();
    }

    Value apply(ParseSession session, Value arg1, Value arg2) {
        throw new UnsupportedOperationException();
    }

    Value apply(ParseSession session, Value arg1, Value arg2, Value arg3) {
        throw new UnsupportedOperationException();
    }
}

