/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractFieldValue;
import org.jsimpledb.parse.expr.AbstractValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Value;

public class StaticFieldValue
extends AbstractFieldValue {
    public StaticFieldValue(Field field) {
        super(field);
        Preconditions.checkArgument(((field.getModifiers() & 8) != 0 ? 1 : 0) != 0, (Object)"field is not static");
    }

    @Override
    public Object get(ParseSession session) {
        try {
            return this.field.get(null);
        }
        catch (Exception e) {
            throw new EvalException("error reading static field `" + this.field.getName() + "' in class `" + this.field.getDeclaringClass().getName() + "': " + e, e);
        }
    }

    @Override
    public void set(ParseSession session, Value value) {
        Object obj = value.get(session);
        try {
            this.field.set(null, obj);
        }
        catch (IllegalArgumentException e) {
            throw new EvalException("invalid " + AbstractValue.describeType(obj, new String[0]) + " for static field `" + this.field.getName() + "' in class `" + this.field.getDeclaringClass().getName() + "'", e);
        }
        catch (Exception e) {
            throw new EvalException("error writing static field `" + this.field.getName() + "' in class `" + this.field.getDeclaringClass().getName() + "': " + e, e);
        }
    }
}

