/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.ClassNode;
import org.jsimpledb.parse.expr.ConstNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.MethodReferenceNode;
import org.jsimpledb.parse.expr.MethodUtil;
import org.jsimpledb.parse.expr.Node;

public class UnboundMethodReferenceNode
extends MethodReferenceNode {
    private final ClassNode classNode;

    public UnboundMethodReferenceNode(ClassNode classNode, String name) {
        super(name);
        Preconditions.checkArgument((classNode != null ? 1 : 0) != 0, (Object)"null classNode");
        this.classNode = classNode;
    }

    @Override
    public <T> Node resolve(ParseSession session, TypeToken<T> type) {
        Class<?> cl = this.classNode.resolveClass(session);
        Method shape = MethodUtil.findFunctionalMethod(type.getRawType());
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        Type[] ptypes = shape.getGenericParameterTypes();
        try {
            MethodHandle handle;
            MethodType shapeType = lookup.unreflect(shape).type();
            if (this.name.equals("new")) {
                if (cl.isArray()) {
                    handle = MethodHandles.insertArguments(lookup.findStatic(Array.class, "newInstance", MethodType.methodType(Object.class, Class.class, Integer.TYPE)), 0, cl.getComponentType());
                } else {
                    Constructor<?> constructor = MethodUtil.findMatchingConstructor(cl, ptypes);
                    handle = lookup.unreflectConstructor(constructor).asType(shapeType);
                }
            } else {
                Method instanceMethod = this.lookupInstanceMethod(cl, ptypes, shape, false);
                Method staticMethod = this.lookupStaticMethod(cl, ptypes, shape, false);
                if (instanceMethod == null && staticMethod == null) {
                    instanceMethod = this.lookupInstanceMethod(cl, ptypes, shape, true);
                    staticMethod = this.lookupStaticMethod(cl, ptypes, shape, true);
                }
                if (instanceMethod == null && staticMethod == null) {
                    throw new EvalException("method " + this.name + "() not found in " + cl);
                }
                if (instanceMethod != null && staticMethod != null) {
                    throw new EvalException("ambiguous invocation of `" + this.name + "()' in " + cl);
                }
                handle = lookup.unreflect(instanceMethod != null ? instanceMethod : staticMethod);
            }
            return new ConstNode(new ConstValue(MethodHandleProxies.asInterfaceInstance(type.getRawType(), handle)));
        }
        catch (IllegalAccessException | NoSuchMethodException | RuntimeException e) {
            throw new EvalException("failed to resolve method " + cl.getName() + "::" + this.name + " for " + type, e);
        }
    }

    private Method lookupInstanceMethod(Class<?> cl, Type[] ptypes, Method shape, boolean searchNonPublic) {
        if (ptypes.length == 0) {
            return null;
        }
        if (!cl.isAssignableFrom(TypeToken.of((Type)ptypes[0]).getRawType()) && !(shape.getGenericParameterTypes()[0] instanceof TypeVariable)) {
            return null;
        }
        Type[] mtypes = new Type[ptypes.length - 1];
        System.arraycopy(ptypes, 1, mtypes, 0, mtypes.length);
        try {
            return MethodUtil.findMatchingMethod(cl, this.name, searchNonPublic, mtypes, shape.getReturnType() != Void.TYPE ? shape.getReturnType() : null, false);
        }
        catch (EvalException e) {
            return null;
        }
    }

    private Method lookupStaticMethod(Class<?> cl, Type[] ptypes, Method shape, boolean searchNonPublic) {
        try {
            return MethodUtil.findMatchingMethod(cl, this.name, searchNonPublic, ptypes, shape.getReturnType() != Void.TYPE ? shape.getReturnType() : null, true);
        }
        catch (EvalException e) {
            return null;
        }
    }
}

