/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractLValue;
import org.jsimpledb.parse.expr.AbstractNamed;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.MethodUtil;
import org.jsimpledb.parse.expr.Value;

public class VarValue
extends AbstractLValue {
    private final String name;

    public VarValue(String name) {
        new AbstractNamed(name){};
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object get(ParseSession session) {
        Value value = (Value)session.getVars().get(this.name);
        if (value == null) {
            throw new EvalException("variable `" + this.name + "' is not defined");
        }
        return MethodUtil.refresh(value.get(session));
    }

    @Override
    public Class<?> getType(ParseSession session) {
        Value value = (Value)session.getVars().get(this.name);
        return value != null ? value.getType(session) : Object.class;
    }

    @Override
    public void set(ParseSession session, Value value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        session.getVars().put(this.name, value);
    }
}

