/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.func;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jsimpledb.SessionMode;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.expr.ExprParser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.func.Function;
import org.jsimpledb.util.ParseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFunction
implements Function {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SpaceParser spaceParser = new SpaceParser();
    protected final String name;

    protected AbstractFunction(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHelpDetail() {
        return this.getHelpSummary();
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.of(SessionMode.CORE_API, SessionMode.JSIMPLEDB);
    }

    protected Node[] parseExpressionParams(ParseSession session, ParseContext ctx, boolean complete, int skippedArgs, int minArgs, int maxArgs) {
        ArrayList<Node> params = new ArrayList<Node>(Math.min(maxArgs, minArgs * 2));
        while (true) {
            if (ctx.isEOF()) {
                ParseException e = new ParseException(ctx, "truncated input");
                if (!params.isEmpty() && params.size() < minArgs) {
                    e.addCompletion(", ");
                } else if (params.size() >= minArgs) {
                    e.addCompletion(")");
                }
                throw e;
            }
            if (ctx.tryLiteral(")")) {
                if (params.size() >= minArgs) break;
                throw new ParseException(ctx, "at least " + (skippedArgs + minArgs) + " argument(s) are required for function " + this.getName() + "()");
            }
            if (params.size() >= maxArgs) {
                throw new ParseException(ctx, "at most " + (skippedArgs + maxArgs) + " argument(s) are allowed for function " + this.getName() + "()");
            }
            if (!params.isEmpty()) {
                if (!ctx.tryLiteral(",")) {
                    throw new ParseException(ctx, "expected `,' between " + this.getName() + "() function parameters").addCompletion(", ");
                }
                this.spaceParser.parse(ctx, complete);
            }
            params.add(this.parseNextParameter(session, ctx, complete, skippedArgs, params));
            ctx.skipWhitespace();
        }
        return params.toArray(new Node[params.size()]);
    }

    protected Node parseNextParameter(ParseSession session, ParseContext ctx, boolean complete, int skippedArgs, List<Node> paramList) {
        return ExprParser.INSTANCE.parse(session, ctx, complete);
    }
}

