/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.func;

import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AtomExprParser;
import org.jsimpledb.parse.expr.ExprParser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.expr.VarNode;
import org.jsimpledb.parse.func.AbstractFunction;
import org.jsimpledb.util.ParseContext;

public abstract class ApplyExprFunction
extends AbstractFunction {
    protected ApplyExprFunction(String name) {
        super(name);
    }

    @Override
    public ParamInfo parseParams(ParseSession session, ParseContext ctx, boolean complete) {
        int mark = ctx.getIndex();
        if (ctx.tryLiteral(")")) {
            throw new ParseException(ctx, "three parameters required for " + this.name + "()");
        }
        Node items = new ExprParser().parse(session, ctx, complete);
        ctx.skipWhitespace();
        if (!ctx.tryLiteral(",")) {
            throw new ParseException(ctx, "expected `,'").addCompletion(", ");
        }
        this.spaceParser.parse(ctx, complete);
        Node param1 = AtomExprParser.INSTANCE.parse(session, ctx, complete);
        if (!(param1 instanceof VarNode)) {
            ctx.setIndex(mark);
            throw new ParseException(ctx, "expected variable as second parameter to " + this.name + "()");
        }
        String variable = ((VarNode)param1).getName();
        ctx.skipWhitespace();
        if (!ctx.tryLiteral(",")) {
            throw new ParseException(ctx, "expected `,'").addCompletion(", ");
        }
        this.spaceParser.parse(ctx, complete);
        Node expr = new ExprParser().parse(session, ctx, complete);
        ctx.skipWhitespace();
        if (!ctx.tryLiteral(")")) {
            throw new ParseException(ctx, "expected `)'").addCompletion(") ");
        }
        return new ParamInfo(variable, items, expr);
    }

    @Override
    public final Value apply(ParseSession session, Object params) {
        return this.apply(session, (ParamInfo)params);
    }

    protected abstract Value apply(ParseSession var1, ParamInfo var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Value evaluate(ParseSession session, String variable, Value value, Node expr) {
        Value result;
        boolean hasPreviousValue = session.getVars().containsKey(variable);
        Value previousValue = hasPreviousValue ? (Value)session.getVars().get(variable) : null;
        session.getVars().put(variable, value);
        try {
            result = expr.evaluate(session);
        }
        finally {
            if (hasPreviousValue) {
                session.getVars().put(variable, previousValue);
            }
        }
        return result;
    }

    static class ParamInfo {
        private final String variable;
        private final Node items;
        private final Node expr;

        ParamInfo(String variable, Node items, Node expr) {
            this.variable = variable;
            this.items = items;
            this.expr = expr;
        }

        public String getVariable() {
            return this.variable;
        }

        public Node getItems() {
            return this.items;
        }

        public Node getExpr() {
            return this.expr;
        }
    }
}

