/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.func;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jsimpledb.SessionMode;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.func.SimpleFunction;

public class CountFunction
extends SimpleFunction {
    public CountFunction() {
        super("count", 1, 1);
    }

    @Override
    public String getHelpSummary() {
        return "Counts the number of elements in the provided iteration or collection";
    }

    @Override
    public String getUsage() {
        return "count(items)";
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    @Override
    protected Value apply(ParseSession session, Value[] params) {
        Set obj = params[0].checkNotNull(session, "count()");
        if (obj instanceof Map) {
            obj = ((Map)((Object)obj)).entrySet();
        }
        if (obj instanceof Collection) {
            return new ConstValue(((Collection)obj).size());
        }
        if (obj instanceof Iterable) {
            obj = ((Iterable)obj).iterator();
        }
        if (obj instanceof Iterator) {
            int count = 0;
            Iterator i = (Iterator)((Object)obj);
            while (i.hasNext()) {
                ++count;
            }
            return new ConstValue(count);
        }
        throw new EvalException("count() cannot be applied to object of type " + obj.getClass().getName());
    }
}

