/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.func;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.jsimpledb.SessionMode;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractValue;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.func.ApplyExprFunction;

public class FilterFunction
extends ApplyExprFunction {
    public FilterFunction() {
        super("filter");
    }

    @Override
    public String getHelpSummary() {
        return "Filters a collection";
    }

    @Override
    public String getUsage() {
        return "filters(items, variable, expression)";
    }

    @Override
    public String getHelpDetail() {
        return "Creates a filtered view of an Iterable, where items are included only if when the item is assigned to the specified variable the specified expression evaluates to true. Maps are also supported, in which case the map's entrySet() is filtered.";
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    @Override
    protected Value apply(ParseSession session, final ApplyExprFunction.ParamInfo params) {
        return new AbstractValue(){

            @Override
            public Object get(ParseSession session) {
                Predicate predicate = item -> FilterFunction.this.evaluate(session, params.getVariable(), new ConstValue(item), params.getExpr()).checkBoolean(session, "filter()");
                Set items = params.getItems().evaluate(session).checkNotNull(session, "filter()");
                if (items instanceof Map) {
                    items = ((Map)((Object)items)).entrySet();
                }
                if (items instanceof NavigableSet) {
                    return Sets.filter((NavigableSet)((NavigableSet)items), (Predicate)predicate);
                }
                if (items instanceof Set) {
                    return Sets.filter(items, (Predicate)predicate);
                }
                if (items instanceof Iterable) {
                    return Iterables.filter((Iterable)items, (Predicate)predicate);
                }
                throw new EvalException("invalid filter() operation on non-Iterable object of type " + items.getClass().getName());
            }
        };
    }
}

