/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.func;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.EnumSet;
import java.util.Iterator;
import org.jsimpledb.SessionMode;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.func.SimpleFunction;

public class LimitFunction
extends SimpleFunction {
    public LimitFunction() {
        super("limit", 2, 2);
    }

    @Override
    public String getUsage() {
        return "limit(items, max)";
    }

    @Override
    public String getHelpSummary() {
        return "Discards items past a maximum count";
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    @Override
    protected Value apply(ParseSession session, Value[] params) {
        final Value value = params[0];
        final int limit = params[1].checkNumeric(session, "limit()").intValue();
        if (limit < 0) {
            throw new EvalException("invalid limit() value " + limit);
        }
        return new AbstractValue(){

            @Override
            public Object get(ParseSession session) {
                Object obj = value.checkNotNull(session, "limit()");
                if (obj instanceof Iterable) {
                    return Iterables.limit((Iterable)((Iterable)obj), (int)limit);
                }
                if (obj instanceof Iterator) {
                    return Iterators.limit((Iterator)((Iterator)obj), (int)limit);
                }
                throw new EvalException("limit() cannot be applied to object of type " + obj.getClass().getName());
            }
        };
    }
}

