/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.func;

import org.jsimpledb.JTransaction;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.parse.ObjTypeParser;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractValue;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.func.AbstractFunction;
import org.jsimpledb.util.ParseContext;

public class QueryVersionFunction
extends AbstractFunction {
    public QueryVersionFunction() {
        super("queryVersion");
    }

    @Override
    public String getHelpSummary() {
        return "Queries the database object version index";
    }

    @Override
    public String getUsage() {
        return "queryVersion([object-type])";
    }

    @Override
    public String getHelpDetail() {
        return "Queries the index of object versions, returning a map from object version to the set of objects with that version. An optional object type restricts returned objects.";
    }

    @Override
    public Object parseParams(ParseSession session, ParseContext ctx, boolean complete) {
        Object result;
        if (ctx.tryLiteral(")")) {
            return null;
        }
        int typeStart = ctx.getIndex();
        try {
            result = new ObjTypeParser().parse(session, ctx, complete);
            ctx.skipWhitespace();
            if (!ctx.tryLiteral(")")) {
                throw new ParseException(ctx);
            }
        }
        catch (ParseException e) {
            ctx.setIndex(typeStart);
            result = this.parseExpressionParams(session, ctx, complete, 0, 1, 1)[0];
        }
        return result;
    }

    @Override
    public Value apply(ParseSession session, final Object param) {
        return new AbstractValue(){

            @Override
            public Object get(ParseSession session) {
                int storageId;
                if (session.getMode().hasJSimpleDB()) {
                    Class type = param instanceof ObjType ? session.getJSimpleDB().getJClass(((ObjType)param).getStorageId()).getType() : (param instanceof Node ? ((Node)param).evaluate(session).checkType(session, QueryVersionFunction.this.getName(), Class.class) : Object.class);
                    return JTransaction.getCurrent().queryVersion(type);
                }
                CoreIndex index = session.getTransaction().queryVersion();
                int n = param instanceof Node ? ((Node)param).evaluate(session).checkType(session, QueryVersionFunction.this.getName(), Integer.class) : (storageId = param instanceof ObjType ? ((ObjType)param).getStorageId() : -1);
                if (storageId != -1) {
                    index = index.filter(1, (KeyFilter)new KeyRanges(ObjId.getKeyRange((int)storageId)));
                }
                return index.asMap();
            }
        };
    }
}

