/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.func;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jsimpledb.SessionMode;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractValue;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.func.ApplyExprFunction;

public class TransformFunction
extends ApplyExprFunction {
    public TransformFunction() {
        super("transform");
    }

    @Override
    public String getHelpSummary() {
        return "Transforms a collection";
    }

    @Override
    public String getUsage() {
        return "transform(items, variable, expression)";
    }

    @Override
    public String getHelpDetail() {
        return "Creates a view of an Iterable where each item is transformed by assigning the item to the specified variable and evaluating the specified expression. Maps are also supported, in which case the map's entrySet() is transformed.";
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    @Override
    protected Value apply(ParseSession session, final ApplyExprFunction.ParamInfo params) {
        return new AbstractValue(){

            @Override
            public Object get(final ParseSession session) {
                Set items = params.getItems().evaluate(session).checkNotNull(session, "transform()");
                if (items instanceof Map) {
                    items = ((Map)((Object)items)).entrySet();
                }
                if (!(items instanceof Iterable)) {
                    throw new EvalException("invalid transform() operation on non-Iterable object of type " + items.getClass().getName());
                }
                return Iterables.transform((Iterable)items, (Function)new Function<Object, Object>(){

                    public Object apply(Object item) {
                        return TransformFunction.this.evaluate(session, params.getVariable(), new ConstValue(item), params.getExpr()).get(session);
                    }
                });
            }
        };
    }
}

