/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.data.Property;
import com.vaadin.data.util.AbstractProperty;
import com.vaadin.data.util.converter.Converter;
import java.util.Locale;

public class ConvertedProperty<P, M>
extends AbstractProperty<P> {
    private final Property<M> property;
    private final Converter<P, M> converter;
    private final Locale locale;
    private ValueChangeListener valueChangeListener;
    private ReadOnlyStatusChangeListener readOnlyStatusChangeListener;

    public ConvertedProperty(Property<M> property, Converter<P, M> converter, Locale locale) {
        if (property == null) {
            throw new IllegalArgumentException("null property");
        }
        if (converter == null) {
            throw new IllegalArgumentException("null converter");
        }
        this.property = property;
        this.converter = converter;
        this.locale = locale;
    }

    public ConvertedProperty(Property<M> property, Converter<P, M> converter) {
        this(property, converter, null);
    }

    public Class<? extends P> getType() {
        return this.converter.getPresentationType();
    }

    public P getValue() {
        return (P)this.converter.convertToPresentation(this.property.getValue(), this.getType(), this.locale);
    }

    public void setValue(P value) {
        this.property.setValue(this.converter.convertToModel(value, this.converter.getModelType(), this.locale));
    }

    public boolean isReadOnly() {
        return this.property.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.property.setReadOnly(readOnly);
    }

    public void addReadOnlyStatusChangeListener(Property.ReadOnlyStatusChangeListener listener) {
        if (this.readOnlyStatusChangeListener == null && this.property instanceof Property.ReadOnlyStatusChangeNotifier) {
            this.readOnlyStatusChangeListener = new ReadOnlyStatusChangeListener();
            ((Property.ReadOnlyStatusChangeNotifier)this.property).addReadOnlyStatusChangeListener((Property.ReadOnlyStatusChangeListener)this.readOnlyStatusChangeListener);
        }
        super.addReadOnlyStatusChangeListener(listener);
    }

    public void addValueChangeListener(Property.ValueChangeListener listener) {
        if (this.valueChangeListener == null && this.property instanceof Property.ValueChangeNotifier) {
            this.valueChangeListener = new ValueChangeListener();
            ((Property.ValueChangeNotifier)this.property).addValueChangeListener((Property.ValueChangeListener)this.valueChangeListener);
        }
        super.addValueChangeListener(listener);
    }

    private class ReadOnlyStatusChangeListener
    implements Property.ReadOnlyStatusChangeListener {
        private ReadOnlyStatusChangeListener() {
        }

        public void readOnlyStatusChange(Property.ReadOnlyStatusChangeEvent event) {
            ConvertedProperty.this.fireReadOnlyStatusChange();
        }
    }

    private class ValueChangeListener
    implements Property.ValueChangeListener {
        private ValueChangeListener() {
        }

        public void valueChange(Property.ValueChangeEvent event) {
            ConvertedProperty.this.fireValueChange();
        }
    }
}

