/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.data.Container;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.ComboBox;
import org.dellroad.stuff.vaadin7.EnumContainer;

public class EnumComboBox
extends ComboBox {
    public EnumComboBox() {
        this(null);
    }

    public <T extends Enum<T>> EnumComboBox(Class<T> enumClass) {
        this(enumClass, false);
    }

    public <T extends Enum<T>> EnumComboBox(Class<T> enumClass, boolean allowNull) {
        this(enumClass, "toString", allowNull);
    }

    public <T extends Enum<T>> EnumComboBox(Class<T> enumClass, String displayPropertyName) {
        this(enumClass, displayPropertyName, false);
    }

    public <T extends Enum<T>> EnumComboBox(Class<T> enumClass, String displayPropertyName, boolean allowNull) {
        this(enumClass != null ? new EnumContainer<T>(enumClass) : null, displayPropertyName, allowNull);
    }

    public EnumComboBox(EnumContainer<?> container, String displayPropertyName, boolean allowNull) {
        if (container != null) {
            this.setContainerDataSource((Container)container);
        }
        this.setNewItemsAllowed(false);
        this.setTextInputAllowed(false);
        this.setFilteringMode(FilteringMode.OFF);
        this.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.setItemCaptionPropertyId(displayPropertyName);
        this.setNullSelectionAllowed(allowNull);
        if (!allowNull && !this.getContainerDataSource().getItemIds().isEmpty()) {
            this.setValue(this.getContainerDataSource().getItemIds().iterator().next());
        }
    }

    public <T extends Enum<T>> void setEnumDataSource(Class<T> enumClass) {
        this.setContainerDataSource((Container)new EnumContainer<T>(enumClass));
        if (!this.isNullSelectionAllowed() && !this.getContainerDataSource().getItemIds().isEmpty()) {
            this.setValue(this.getContainerDataSource().getItemIds().iterator().next());
        }
    }
}

