/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import java.util.List;
import org.dellroad.stuff.java.EnumUtil;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.SelfKeyedContainer;

public class EnumContainer<T extends Enum<T>>
extends SelfKeyedContainer<T> {
    public static final String NAME_PROPERTY = "name";
    public static final String VALUE_PROPERTY = "value";
    public static final String ORDINAL_PROPERTY = "ordinal";
    public static final String TO_STRING_PROPERTY = "toString";
    private static final PropertyDef<String> NAME_PROPERTY_DEF = new PropertyDef<String>("name", String.class);
    private static final PropertyDef<Enum> VALUE_PROPERTY_DEF = new PropertyDef<Enum>("value", Enum.class);
    private static final PropertyDef<Integer> ORDINAL_PROPERTY_DEF = new PropertyDef<Integer>("ordinal", Integer.class);
    private static final PropertyDef<String> TO_STRING_PROPERTY_DEF = new PropertyDef<String>("toString", String.class);

    public EnumContainer(Class<T> type) {
        super(type);
        this.setProperty(NAME_PROPERTY_DEF);
        this.setProperty(VALUE_PROPERTY_DEF);
        this.setProperty(ORDINAL_PROPERTY_DEF);
        this.setProperty(TO_STRING_PROPERTY_DEF);
        this.load(this.getExposedValues(type));
    }

    protected List<T> getExposedValues(Class<T> type) {
        return EnumUtil.getValues(type);
    }

    @Override
    public <V> V getPropertyValue(T value, PropertyDef<V> propertyDef) {
        if (propertyDef.equals(VALUE_PROPERTY_DEF)) {
            return propertyDef.getType().cast(value);
        }
        if (propertyDef.equals(VALUE_PROPERTY_DEF)) {
            return propertyDef.getType().cast(value);
        }
        if (propertyDef.equals(ORDINAL_PROPERTY_DEF)) {
            return propertyDef.getType().cast(((Enum)value).ordinal());
        }
        if (propertyDef.equals(TO_STRING_PROPERTY_DEF)) {
            return propertyDef.getType().cast(((Enum)value).toString());
        }
        return super.getPropertyValue(value, propertyDef);
    }
}

