/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.ui.Table;
import java.io.Serializable;
import java.util.Comparator;

public class PropertyDef<T>
implements Serializable {
    public static final Comparator<PropertyDef<?>> SORT_BY_NAME = new Comparator<PropertyDef<?>>(){

        @Override
        public int compare(PropertyDef<?> p1, PropertyDef<?> p2) {
            return p1.getName().compareTo(p2.getName());
        }
    };
    private static final long serialVersionUID = -8991380517167562622L;
    private final String name;
    private final Class<T> type;
    private final T defaultValue;

    public PropertyDef(String name, Class<T> type) {
        this(name, type, null);
    }

    public PropertyDef(String name, Class<T> type, T defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getPropertyId() {
        return this.getName();
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public ObjectProperty<T> createProperty(T value, boolean readOnly) {
        return new ObjectProperty(value, this.getType(), readOnly);
    }

    public ObjectProperty<T> createProperty(T value) {
        return this.createProperty(value, false);
    }

    public ObjectProperty<T> createProperty() {
        return this.createProperty(this.getDefaultValue());
    }

    public Property<T> get(Item item) {
        return this.cast(item.getItemProperty((Object)this.getPropertyId()));
    }

    public Property<T> get(Container container, Object itemId) {
        return this.cast(container.getContainerProperty(itemId, (Object)this.getPropertyId()));
    }

    public Property<T> cast(Property<?> property) {
        if (property == null) {
            return null;
        }
        if (property.getType() != this.getType()) {
            throw new ClassCastException("property type " + property.getType().getName() + " != definition type " + this.getType().getName());
        }
        return property;
    }

    public boolean addTo(Container container) {
        return container.addContainerProperty((Object)this.getPropertyId(), this.getType(), this.getDefaultValue());
    }

    public boolean addTo(Item item, Property<T> property) {
        return item.addItemProperty((Object)this.getPropertyId(), property);
    }

    public boolean addTo(Table table) {
        return table.addContainerProperty((Object)this.getPropertyId(), this.getType(), this.getDefaultValue());
    }

    public T read(Item item) {
        Property<T> property = this.get(item);
        if (property == null) {
            return null;
        }
        return this.type.cast(property.getValue());
    }

    public boolean isSortable() {
        return Comparable.class.isAssignableFrom(this.type);
    }

    public int sort(T value1, T value2) {
        if (value1 == null != (value2 == null)) {
            return value1 == null ? -1 : 1;
        }
        if (value1 == null && value2 == null) {
            return 0;
        }
        try {
            return ((Comparable)value1).compareTo(value2);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode() ^ (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PropertyDef that = (PropertyDef)obj;
        return this.name.equals(that.name) && this.type == that.type && (this.defaultValue != null ? this.defaultValue.equals(that.defaultValue) : that.defaultValue == null);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[name=\"" + this.name + "\",type=" + this.type.getName() + ",defaultValue=" + this.defaultValue + "]";
    }
}

