/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.dellroad.stuff.vaadin7.SpringVaadinSessionListener;

public class SpringVaadinServlet
extends VaadinServlet {
    public static final String CONFIG_LOCATION_PARAMETER = "configLocation";
    public static final String LISTENER_CLASS_PARAMETER = "listenerClass";
    public static final String APPLICATION_NAME_PARAMETER = "applicationName";
    public static final String SESSION_TRACKING_PARAMETER = "sessionTracking";
    public static final String MAX_SESSIONS_PARAMETER = "maxSessions";
    private final WeakHashMap<VaadinSession, Void> liveSessions = new WeakHashMap();
    private String servletName;

    public void init(ServletConfig config) throws ServletException {
        this.servletName = config.getServletName();
        if (this.servletName == null) {
            throw new IllegalArgumentException("null servlet name");
        }
        super.init(config);
    }

    protected void servletInitialized() throws ServletException {
        SpringVaadinSessionListener sessionListener;
        if (this.servletName == null) {
            throw new IllegalArgumentException("servlet not initialized");
        }
        super.servletInitialized();
        VaadinServletService servletService = this.getService();
        Properties params = servletService.getDeploymentConfiguration().getInitParameters();
        String contextLocation = params.getProperty(CONFIG_LOCATION_PARAMETER);
        String listenerClassName = params.getProperty(LISTENER_CLASS_PARAMETER);
        String applicationName = params.getProperty(APPLICATION_NAME_PARAMETER);
        if (applicationName == null) {
            applicationName = this.servletName;
        }
        Class<SpringVaadinSessionListener> listenerClass = SpringVaadinSessionListener.class;
        if (listenerClassName != null) {
            try {
                listenerClass = Class.forName(listenerClassName, false, Thread.currentThread().getContextClassLoader()).asSubclass(SpringVaadinSessionListener.class);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException("error finding class " + listenerClassName, (Throwable)e);
            }
        }
        try {
            sessionListener = (SpringVaadinSessionListener)listenerClass.getConstructor(String.class, String.class).newInstance(applicationName, contextLocation);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("error instantiating " + listenerClass, (Throwable)e);
        }
        servletService.addSessionInitListener((SessionInitListener)sessionListener);
        servletService.addSessionDestroyListener((SessionDestroyListener)sessionListener);
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        Properties params = deploymentConfiguration.getInitParameters();
        boolean sessionTracking = Boolean.valueOf(params.getProperty(SESSION_TRACKING_PARAMETER));
        int maxSessionsParam = 0;
        try {
            maxSessionsParam = Integer.parseInt(params.getProperty(MAX_SESSIONS_PARAMETER));
        }
        catch (Exception exception) {}
        final int maxSessions = maxSessionsParam;
        if (!sessionTracking) {
            return super.createServletService(deploymentConfiguration);
        }
        VaadinServletService service = new VaadinServletService(this, deploymentConfiguration){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected VaadinSession createVaadinSession(VaadinRequest request) throws ServiceException {
                VaadinSession session;
                WeakHashMap weakHashMap = SpringVaadinServlet.this.liveSessions;
                synchronized (weakHashMap) {
                    if (maxSessions > 0 && SpringVaadinServlet.this.liveSessions.size() >= maxSessions) {
                        throw new ServiceException("The maximum number of active sessions has been reached");
                    }
                    session = super.createVaadinSession(request);
                    SpringVaadinServlet.this.liveSessions.put(session, null);
                }
                return session;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fireSessionDestroy(VaadinSession session) {
                WeakHashMap weakHashMap = SpringVaadinServlet.this.liveSessions;
                synchronized (weakHashMap) {
                    SpringVaadinServlet.this.liveSessions.remove(session);
                }
                super.fireSessionDestroy(session);
            }
        };
        service.init();
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VaadinSession> getSessions() {
        WeakHashMap<VaadinSession, Void> weakHashMap = this.liveSessions;
        synchronized (weakHashMap) {
            return new ArrayList<VaadinSession>(this.liveSessions.keySet());
        }
    }

    public static SpringVaadinServlet getServlet(VaadinSession session) {
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        if (!(session.getService() instanceof VaadinServletService)) {
            throw new IllegalStateException("the VaadinService associated with the session is not a VaadinServletService instance");
        }
        VaadinServletService service = (VaadinServletService)session.getService();
        if (!(service.getServlet() instanceof SpringVaadinServlet)) {
            throw new IllegalStateException("the VaadinServlet associated with the session is not a SpringVaadinServlet instance");
        }
        return (SpringVaadinServlet)service.getServlet();
    }
}

