/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.VaadinSession;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.Future;
import org.dellroad.stuff.vaadin7.VaadinUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinApplication
implements Serializable {
    private static final long serialVersionUID = -4202507689739224846L;
    private static final Class<VaadinApplication> ATTRIBUTE_KEY = VaadinApplication.class;
    protected transient Logger log = LoggerFactory.getLogger(this.getClass());
    private transient VaadinSession session;

    public VaadinApplication() {
        this(VaadinUtil.getCurrentSession());
    }

    public VaadinApplication(VaadinSession session) {
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        this.session = session;
        VaadinApplication vaadinApplication = (VaadinApplication)this.session.getAttribute(ATTRIBUTE_KEY);
        if (vaadinApplication != null) {
            throw new IllegalStateException("there is already a VaadinApplication associated with VaadinSession " + this.session + ": " + vaadinApplication + "; did you accidentally declare more than one instance of" + " VaadinApplication in the Vaadin Spring XML application context?");
        }
        VaadinApplication.setAttribute(this.session, ATTRIBUTE_KEY, this);
        this.init();
    }

    protected void init() {
    }

    public VaadinSession getSession() {
        return this.session;
    }

    public void close() {
        this.session.close();
    }

    public static VaadinApplication get() {
        return VaadinApplication.get(VaadinApplication.class);
    }

    public static <T extends VaadinApplication> T get(Class<T> clazz) {
        return VaadinApplication.get(VaadinUtil.getCurrentSession(), clazz);
    }

    public static <T extends VaadinApplication> T get(VaadinSession session, Class<T> clazz) {
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("null clazz");
        }
        VaadinApplication vaadinApplication = (VaadinApplication)session.getAttribute(ATTRIBUTE_KEY);
        if (vaadinApplication == null) {
            throw new IllegalStateException("there is no VaadinApplication associated with the current VaadinSession; did you declare an instance of VaadinApplication in the Vaadin Spring XML application context? And if declared scope=\"session\", did you register Spring's RequestContextListener in web.xml?");
        }
        if (!clazz.isInstance(vaadinApplication)) {
            throw new IllegalStateException("there is a VaadinApplication associated with the current VaadinSession but it is not an instance of " + clazz + "; instead it has type " + vaadinApplication.getClass().getName());
        }
        return (T)((VaadinApplication)clazz.cast(vaadinApplication));
    }

    public void invoke(Runnable action) {
        VaadinUtil.invoke(this.session, action);
    }

    public Future<Void> invokeLater(Runnable action) {
        return VaadinUtil.invokeLater(this.session, action);
    }

    public void addSessionDestroyListener(SessionDestroyListener listener) {
        VaadinUtil.addSessionDestroyListener(this.session, listener);
    }

    public void removeSessionDestroyListener(SessionDestroyListener listener) {
        VaadinUtil.removeSessionDestroyListener(this.session, listener);
    }

    private static <T> void setAttribute(VaadinSession session, Class<T> clazz, Object value) {
        session.setAttribute(clazz, clazz.cast(value));
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.session = VaadinUtil.getCurrentSession();
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

