/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.VaadinSession;
import java.util.HashMap;
import org.dellroad.stuff.vaadin7.VaadinUtil;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;

public class VaadinApplicationScope
implements Scope,
BeanFactoryPostProcessor,
SessionDestroyListener {
    public static final String VAADIN_SERVICE_SESSION_KEY = "vaadinServiceSession";
    public static final String SCOPE_NAME = "vaadinApplication";
    private final HashMap<VaadinSession, SessionBeanHolder> beanHolders = new HashMap();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope(SCOPE_NAME, (Scope)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroy(SessionDestroyEvent event) {
        SessionBeanHolder beanHolder;
        VaadinSession session = event.getSession();
        VaadinApplicationScope vaadinApplicationScope = this;
        synchronized (vaadinApplicationScope) {
            beanHolder = this.beanHolders.remove(session);
        }
        if (beanHolder != null) {
            beanHolder.close();
        }
    }

    public synchronized Object get(String name, ObjectFactory<?> objectFactory) {
        return this.getSessionBeanHolder(true).getBean(name, objectFactory);
    }

    public synchronized Object remove(String name) {
        SessionBeanHolder beanHolder = this.getSessionBeanHolder(false);
        return beanHolder != null ? beanHolder.remove(name) : null;
    }

    public synchronized void registerDestructionCallback(String name, Runnable callback) {
        this.getSessionBeanHolder(true).registerDestructionCallback(name, callback);
    }

    public String getConversationId() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            return null;
        }
        return String.valueOf(session.getClass().getName()) + "@" + System.identityHashCode(session);
    }

    public Object resolveContextualObject(String key) {
        if (VAADIN_SERVICE_SESSION_KEY.equals(key)) {
            return VaadinSession.getCurrent();
        }
        return null;
    }

    private synchronized SessionBeanHolder getSessionBeanHolder(boolean create) {
        VaadinSession session = VaadinUtil.getCurrentSession();
        VaadinUtil.addSessionDestroyListener(session, this);
        SessionBeanHolder beanHolder = this.beanHolders.get(session);
        if (beanHolder == null && create) {
            beanHolder = new SessionBeanHolder();
            this.beanHolders.put(session, beanHolder);
        }
        return beanHolder;
    }

    private static class SessionBeanHolder {
        private final HashMap<String, Object> beans = new HashMap();
        private final HashMap<String, Runnable> destructionCallbacks = new HashMap();

        private SessionBeanHolder() {
        }

        public Object getBean(String name, ObjectFactory<?> objectFactory) {
            Object bean = this.beans.get(name);
            if (bean == null) {
                bean = objectFactory.getObject();
                this.beans.put(name, bean);
            }
            return bean;
        }

        public Object remove(String name) {
            this.destructionCallbacks.remove(name);
            return this.beans.remove(name);
        }

        public void registerDestructionCallback(String name, Runnable callback) {
            this.destructionCallbacks.put(name, callback);
        }

        public void close() {
            for (Runnable callback : this.destructionCallbacks.values()) {
                callback.run();
            }
            this.beans.clear();
            this.destructionCallbacks.clear();
        }
    }
}

