/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.VaadinSession;
import org.dellroad.stuff.vaadin7.VaadinApplication;
import org.dellroad.stuff.vaadin7.VaadinUtil;
import org.slf4j.LoggerFactory;

public abstract class VaadinExternalListener<S> {
    private final S eventSource;
    private final VaadinSession session;
    private final CloseListener closeListener = new CloseListener();
    private volatile boolean asynchronous;

    protected VaadinExternalListener(S eventSource) {
        this(eventSource, VaadinUtil.getCurrentSession());
    }

    protected VaadinExternalListener(S eventSource, VaadinApplication application) {
        this(eventSource, application.getSession());
    }

    protected VaadinExternalListener(S eventSource, VaadinSession session) {
        if (eventSource == null) {
            throw new IllegalArgumentException("null eventSource");
        }
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        this.eventSource = eventSource;
        this.session = session;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public void register() {
        VaadinUtil.addSessionDestroyListener(this.session, this.closeListener);
        this.register(this.eventSource);
    }

    public void unregister() {
        VaadinUtil.removeSessionDestroyListener(this.session, this.closeListener);
        this.unregister(this.eventSource);
    }

    public final VaadinSession getSession() {
        return this.session;
    }

    public final S getEventSource() {
        return this.eventSource;
    }

    protected void handleEvent(final Runnable action) {
        if (this.asynchronous) {
            VaadinUtil.invokeLater(this.getSession(), new Runnable(){

                @Override
                public void run() {
                    try {
                        action.run();
                    }
                    catch (RuntimeException e) {
                        LoggerFactory.getLogger(VaadinExternalListener.this.getClass()).error("exception in asynchrnous listener", (Throwable)e);
                        throw e;
                    }
                }
            });
        } else {
            VaadinUtil.invoke(this.getSession(), action);
        }
    }

    protected abstract void register(S var1);

    protected abstract void unregister(S var1);

    private final class CloseListener
    implements SessionDestroyListener {
        private CloseListener() {
        }

        public void sessionDestroy(SessionDestroyEvent event) {
            VaadinExternalListener.this.unregister();
        }
    }
}

