/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import java.util.concurrent.Future;

public final class VaadinUtil {
    private VaadinUtil() {
    }

    public static void assertSession(VaadinSession session) {
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        VaadinSession currentSession = VaadinSession.getCurrent();
        if (currentSession == null) {
            throw new IllegalStateException("there is no VaadinSession associated with the current thread");
        }
        if (currentSession != session) {
            throw new IllegalStateException("the VaadinSession associated with the current thread " + currentSession + " is not the same session as the given one " + session);
        }
        if (!session.hasLock()) {
            throw new IllegalStateException("the VaadinSession associated with the current thread " + currentSession + " is not locked by this thread");
        }
    }

    public static VaadinSession getCurrentSession() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            throw new IllegalStateException("there is no VaadinSession associated with the current thread; are we executing within a Vaadin HTTP request or VaadinUtil.invoke()?");
        }
        return session;
    }

    public static VaadinRequest getCurrentRequest() {
        VaadinRequest request = VaadinService.getCurrentRequest();
        if (request == null) {
            throw new IllegalStateException("there is no VaadinRequest associated with the current thread; are we executing within a Vaadin HTTP request?");
        }
        return request;
    }

    public static void invoke(VaadinSession session, Runnable action) {
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        session.accessSynchronously(action);
    }

    public static Future<Void> invokeLater(VaadinSession session, Runnable action) {
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        return session.access(action);
    }

    public static void addSessionDestroyListener(VaadinSession session, SessionDestroyListener listener) {
        session.getService().addSessionDestroyListener((SessionDestroyListener)new LeakAvoidingDestroyListener(session, listener));
    }

    public static void removeSessionDestroyListener(VaadinSession session, SessionDestroyListener listener) {
        session.getService().removeSessionDestroyListener((SessionDestroyListener)new LeakAvoidingDestroyListener(session, listener));
    }

    private static class LeakAvoidingDestroyListener
    implements SessionDestroyListener {
        private final VaadinSession session;
        private final SessionDestroyListener listener;

        LeakAvoidingDestroyListener(VaadinSession session, SessionDestroyListener listener) {
            if (session == null) {
                throw new IllegalArgumentException("null session");
            }
            if (listener == null) {
                throw new IllegalArgumentException("null listener");
            }
            this.session = session;
            this.listener = listener;
        }

        public void sessionDestroy(SessionDestroyEvent event) {
            VaadinSession closedSession = event.getSession();
            if (closedSession == this.session) {
                this.session.getService().removeSessionDestroyListener((SessionDestroyListener)this);
                this.listener.sessionDestroy(event);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            LeakAvoidingDestroyListener that = (LeakAvoidingDestroyListener)obj;
            return this.session == that.session && this.listener.equals(that.listener);
        }

        public int hashCode() {
            return this.session.hashCode() ^ this.listener.hashCode();
        }
    }
}

