/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.fdb;

import com.foundationdb.Database;
import com.foundationdb.FDB;
import com.foundationdb.FDBException;
import com.foundationdb.NetworkOptions;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVDatabaseException;
import org.jsimpledb.kv.fdb.FoundationKVTransaction;

public class FoundationKVDatabase
implements KVDatabase {
    public static final int API_VERSION = 300;
    private final FDB fdb = FDB.selectAPIVersion((int)300);
    private final NetworkOptions options = this.fdb.options();
    private String clusterFilePath;
    private byte[] databaseName = new byte[]{68, 66};
    private byte[] keyPrefix;
    private Executor executor;
    private Database database;
    private boolean started;

    public NetworkOptions getNetworkOptions() {
        return this.options;
    }

    public synchronized void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public synchronized void setClusterFilePath(String clusterFilePath) {
        this.clusterFilePath = clusterFilePath;
    }

    public synchronized void setDatabaseName(byte[] databaseName) {
        Preconditions.checkState((databaseName != null ? 1 : 0) != 0, (Object)"null databaseName");
        this.databaseName = (byte[])databaseName.clone();
    }

    public synchronized byte[] getKeyPrefix() {
        return (byte[])this.keyPrefix.clone();
    }

    public synchronized void setKeyPrefix(byte[] keyPrefix) {
        Preconditions.checkState((this.database == null ? 1 : 0) != 0, (Object)"already started");
        Preconditions.checkArgument((keyPrefix == null || keyPrefix.length == 0 || keyPrefix[0] != -1 ? 1 : 0) != 0, (Object)"prefix starts with 0xff");
        this.keyPrefix = keyPrefix != null && keyPrefix.length > 0 ? (byte[])keyPrefix.clone() : null;
    }

    public synchronized Database getDatabase() {
        Preconditions.checkState((this.database != null ? 1 : 0) != 0, (Object)"not started");
        return this.database;
    }

    @PostConstruct
    public synchronized void start() {
        if (this.database != null) {
            return;
        }
        if (this.started) {
            throw new UnsupportedOperationException("restarts not supported");
        }
        this.database = this.fdb.open(this.clusterFilePath, this.databaseName);
        if (this.executor != null) {
            this.fdb.startNetwork(this.executor);
        } else {
            this.fdb.startNetwork();
        }
        this.started = true;
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.database == null) {
            return;
        }
        this.fdb.stopNetwork();
        this.database = null;
    }

    public FoundationKVTransaction createTransaction(Map<String, ?> options) {
        return this.createTransaction();
    }

    public synchronized FoundationKVTransaction createTransaction() {
        Preconditions.checkState((this.database != null ? 1 : 0) != 0, (Object)"not started");
        try {
            return new FoundationKVTransaction(this, this.keyPrefix);
        }
        catch (FDBException e) {
            throw new KVDatabaseException((KVDatabase)this, (Throwable)e);
        }
    }
}

