/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.fdb;

import com.foundationdb.Disposable;
import com.foundationdb.FDBException;
import com.foundationdb.KeyValue;
import com.foundationdb.MutationType;
import com.foundationdb.Range;
import com.foundationdb.Transaction;
import com.foundationdb.async.AsyncIterator;
import com.foundationdb.async.PartialFuture;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Bytes;
import java.io.Closeable;
import java.util.Iterator;
import java.util.concurrent.Future;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.jsimpledb.kv.TransactionTimeoutException;
import org.jsimpledb.kv.fdb.FoundationKVDatabase;
import org.jsimpledb.kv.fdb.FutureWrapper;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.CloseableIterator;

public class FoundationKVTransaction
implements KVTransaction {
    private static final byte[] MIN_KEY = ByteUtil.EMPTY;
    private static final byte[] MAX_KEY = new byte[]{-1};
    private final FoundationKVDatabase store;
    private final Transaction tx;
    private final byte[] keyPrefix;
    private volatile boolean stale;
    private volatile boolean canceled;

    FoundationKVTransaction(FoundationKVDatabase store, byte[] keyPrefix) {
        Preconditions.checkArgument((store != null ? 1 : 0) != 0, (Object)"null store");
        this.store = store;
        this.tx = this.store.getDatabase().createTransaction();
        this.keyPrefix = keyPrefix;
    }

    public FoundationKVDatabase getKVDatabase() {
        return this.store;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public void setTimeout(long timeout) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout < 0");
        this.tx.options().setTimeout(timeout);
    }

    public Future<Void> watchKey(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        try {
            return new FutureWrapper<Void>((PartialFuture<Void>)this.tx.watch(this.addPrefix(key)));
        }
        catch (FDBException e) {
            throw this.wrapException(e);
        }
    }

    public byte[] get(byte[] key) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        Preconditions.checkArgument((key.length == 0 || key[0] != -1 ? 1 : 0) != 0, (Object)"key starts with 0xff");
        try {
            return (byte[])this.tx.get(this.addPrefix(key)).get();
        }
        catch (FDBException e) {
            throw this.wrapException(e);
        }
    }

    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        if (minKey != null && minKey.length > 0 && minKey[0] == -1) {
            return null;
        }
        return this.getFirstInRange(minKey, maxKey, false);
    }

    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        if (maxKey != null && maxKey.length > 0 && maxKey[0] == -1) {
            maxKey = null;
        }
        return this.getFirstInRange(minKey, maxKey, true);
    }

    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        AsyncIterator i;
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        if (minKey != null && minKey.length > 0 && minKey[0] == -1) {
            minKey = MAX_KEY;
        }
        if (maxKey != null && maxKey.length > 0 && maxKey[0] == -1) {
            maxKey = null;
        }
        Preconditions.checkArgument((minKey == null || maxKey == null || ByteUtil.compare((byte[])minKey, (byte[])maxKey) <= 0 ? 1 : 0) != 0, (Object)"minKey > maxKey");
        try {
            i = this.tx.getRange(this.addPrefix(minKey, maxKey), 0, reverse).iterator();
        }
        catch (FDBException e) {
            throw this.wrapException(e);
        }
        return CloseableIterator.wrap((Iterator)Iterators.transform((Iterator)i, kv -> new KVPair(this.removePrefix(kv.getKey()), kv.getValue())), (AutoCloseable)new DisposableCloseable((Disposable)i));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KVPair getFirstInRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        try {
            AsyncIterator i = this.tx.getRange(this.addPrefix(minKey, maxKey), 0, reverse).iterator();
            try {
                if (!i.hasNext()) {
                    KVPair kVPair = null;
                    return kVPair;
                }
                KeyValue kv = (KeyValue)i.next();
                KVPair kVPair = new KVPair(this.removePrefix(kv.getKey()), kv.getValue());
                return kVPair;
            }
            finally {
                i.dispose();
            }
        }
        catch (FDBException e) {
            throw this.wrapException(e);
        }
    }

    public void put(byte[] key, byte[] value) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        Preconditions.checkArgument((key.length == 0 || key[0] != -1 ? 1 : 0) != 0, (Object)"key starts with 0xff");
        try {
            this.tx.set(this.addPrefix(key), value);
        }
        catch (FDBException e) {
            throw this.wrapException(e);
        }
    }

    public void remove(byte[] key) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        Preconditions.checkArgument((key.length == 0 || key[0] != -1 ? 1 : 0) != 0, (Object)"key starts with 0xff");
        try {
            this.tx.clear(this.addPrefix(key));
        }
        catch (FDBException e) {
            throw this.wrapException(e);
        }
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        if (minKey != null && minKey.length > 0 && minKey[0] == -1) {
            return;
        }
        if (maxKey != null && maxKey.length > 0 && maxKey[0] == -1) {
            maxKey = null;
        }
        Preconditions.checkArgument((minKey == null || maxKey == null || ByteUtil.compare((byte[])minKey, (byte[])maxKey) <= 0 ? 1 : 0) != 0, (Object)"minKey > maxKey");
        try {
            this.tx.clear(this.addPrefix(minKey, maxKey));
        }
        catch (FDBException e) {
            throw this.wrapException(e);
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setReadOnly(boolean readOnly) {
        throw new UnsupportedOperationException();
    }

    public void commit() {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.stale = true;
        try {
            this.tx.commit().get();
        }
        catch (FDBException e) {
            throw this.wrapException(e);
        }
        finally {
            this.cancel();
        }
    }

    public void rollback() {
        if (this.stale) {
            return;
        }
        this.stale = true;
        this.cancel();
    }

    public CloseableKVStore mutableSnapshot() {
        throw new UnsupportedOperationException();
    }

    private void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        try {
            this.tx.cancel();
        }
        catch (FDBException fDBException) {
            // empty catch block
        }
    }

    public byte[] encodeCounter(long value) {
        ByteWriter writer = new ByteWriter(8);
        ByteUtil.writeLong((ByteWriter)writer, (long)value);
        byte[] bytes = writer.getBytes();
        this.reverse(bytes);
        return bytes;
    }

    public long decodeCounter(byte[] bytes) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        Preconditions.checkArgument((bytes.length == 8 ? 1 : 0) != 0, (Object)"invalid encoded counter value length != 8");
        bytes = (byte[])bytes.clone();
        this.reverse(bytes);
        return ByteUtil.readLong((ByteReader)new ByteReader(bytes));
    }

    public void adjustCounter(byte[] key, long amount) {
        if (this.stale) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.tx.mutate(MutationType.ADD, this.addPrefix(key), this.encodeCounter(amount));
    }

    private void reverse(byte[] bytes) {
        int i = 0;
        for (int j = bytes.length - 1; i < j; ++i, --j) {
            byte temp = bytes[i];
            bytes[i] = bytes[j];
            bytes[j] = temp;
        }
    }

    public KVTransactionException wrapException(FDBException e) {
        try {
            this.cancel();
        }
        catch (KVTransactionException kVTransactionException) {
            // empty catch block
        }
        switch (e.getCode()) {
            case 1007: 
            case 1031: {
                return new TransactionTimeoutException((KVTransaction)this, (Throwable)e);
            }
            case 1020: 
            case 1021: {
                return new RetryTransactionException((KVTransaction)this, (Throwable)e);
            }
        }
        return new KVTransactionException((KVTransaction)this, (Throwable)e);
    }

    private byte[] addPrefix(byte[] key) {
        return this.keyPrefix != null ? Bytes.concat((byte[][])new byte[][]{this.keyPrefix, key}) : key;
    }

    private Range addPrefix(byte[] minKey, byte[] maxKey) {
        return new Range(this.addPrefix(minKey != null ? minKey : MIN_KEY), this.addPrefix(maxKey != null ? maxKey : MAX_KEY));
    }

    private byte[] removePrefix(byte[] key) {
        if (this.keyPrefix == null) {
            return key;
        }
        if (!ByteUtil.isPrefixOf((byte[])this.keyPrefix, (byte[])key)) {
            throw new IllegalArgumentException("read key " + ByteUtil.toString((byte[])key) + " not having " + ByteUtil.toString((byte[])this.keyPrefix) + " as a prefix");
        }
        byte[] stripped = new byte[key.length - this.keyPrefix.length];
        System.arraycopy(key, this.keyPrefix.length, stripped, 0, stripped.length);
        return stripped;
    }

    private static class DisposableCloseable
    implements Closeable {
        private final Disposable target;

        DisposableCloseable(Disposable target) {
            this.target = target;
        }

        @Override
        public void close() {
            this.target.dispose();
        }
    }
}

