/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.fdb;

import com.foundationdb.async.PartialFuture;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class FutureWrapper<V>
implements Future<V> {
    private static final int WAIT_GRANULARITY_MILLIS = 20;
    private final PartialFuture<V> future;
    private volatile boolean cancelled;

    FutureWrapper(PartialFuture<V> future) {
        Preconditions.checkArgument((future != null ? 1 : 0) != 0, (Object)"null future");
        this.future = future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.future.isDone()) {
            return false;
        }
        this.cancelled = true;
        this.future.cancel();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        while (true) {
            try {
                return this.get(1L, TimeUnit.DAYS);
            }
            catch (TimeoutException e) {
                continue;
            }
            break;
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        do {
            if (this.future.isDone()) {
                try {
                    return (V)this.future.get();
                }
                catch (Throwable t) {
                    throw new ExecutionException(t);
                }
            }
            Thread.sleep(20L);
        } while (System.nanoTime() - deadline < 0L);
        throw new TimeoutException();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FutureWrapper that = (FutureWrapper)obj;
        return this.future.equals(that.future);
    }

    public int hashCode() {
        return this.future.hashCode();
    }
}

