/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlySpannerView
extends AbstractKVStore
implements CloseableKVStore {
    private static final byte[] TOP = new byte[]{-1};
    private static final Key TOP_KEY = Key.of((Object[])new Object[]{ByteArray.copyFrom((byte[])TOP)});
    private static final List<String> V_COL = Arrays.asList("val");
    private static final List<String> KV_COL = Arrays.asList("key", "val");
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final String tableName;
    protected final ReadContext context;
    protected final Function<? super SpannerException, RuntimeException> exceptionMapper;

    public ReadOnlySpannerView(String tableName, ReadContext context, Function<? super SpannerException, RuntimeException> exceptionMapper) {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((context != null ? 1 : 0) != 0);
        this.tableName = tableName;
        this.context = context;
        this.exceptionMapper = exceptionMapper;
    }

    public ReadOnlySpannerView(String tableName, ReadContext context) {
        this(tableName, context, null);
    }

    public byte[] get(byte[] key) {
        try {
            byte[] val;
            Struct row = this.context.readRow(this.tableName, Key.of((Object[])new Object[]{ByteArray.copyFrom((byte[])key)}), V_COL);
            byte[] byArray = val = row != null ? row.getBytes(0).toByteArray() : null;
            if (this.log.isTraceEnabled()) {
                this.log.trace("spanner: get(): {} -> {}", (Object)ByteUtil.toString((byte[])key), (Object)ByteUtil.toString((byte[])val));
            }
            return val;
        }
        catch (SpannerException e) {
            throw this.exceptionMapper != null ? this.exceptionMapper.apply(e) : e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("spanner: getAtLeast():\n  minKey={}\n  maxKey={}", (Object)ByteUtil.toString((byte[])minKey), (Object)ByteUtil.toString((byte[])maxKey));
        }
        try (ResultSet resultSet = this.getPairs(minKey, maxKey, Options.limit((long)1L));){
            KVPair kVPair = resultSet.next() ? ReadOnlySpannerView.kv(resultSet.getCurrentRowAsStruct()) : null;
            return kVPair;
        }
        catch (SpannerException e) {
            Throwable throwable;
            if (this.exceptionMapper != null) {
                throwable = this.exceptionMapper.apply(e);
                throw throwable;
            }
            throwable = e;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        if (minKey != null && minKey.length == 0) {
            minKey = null;
        }
        try {
            Statement.Builder builder = Statement.newBuilder((String)("SELECT key, val FROM " + this.tableName));
            this.addMaxKey(builder, maxKey, this.addMinKey(builder, minKey, false));
            builder.append(" ORDER BY key DESC LIMIT 1");
            if (this.log.isTraceEnabled()) {
                this.log.trace("spanner: getAtMost():\n  maxKey={}\n  minKey={}\n  query={}", new Object[]{ByteUtil.toString((byte[])maxKey), ByteUtil.toString((byte[])minKey), builder.build()});
            }
            try (ResultSet resultSet = this.context.executeQuery(builder.build(), new Options.QueryOption[0]);){
                KVPair kVPair = resultSet.next() ? ReadOnlySpannerView.kv(resultSet.getCurrentRowAsStruct()) : null;
                return kVPair;
            }
        }
        catch (SpannerException e) {
            Throwable throwable;
            if (this.exceptionMapper != null) {
                throwable = this.exceptionMapper.apply(e);
                throw throwable;
            }
            throwable = e;
            throw throwable;
        }
    }

    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        if (minKey != null && minKey.length == 0) {
            minKey = null;
        }
        try {
            if (!reverse) {
                return new Iter(this.getPairs(minKey, maxKey, new Options.ReadOption[0]));
            }
            Statement.Builder builder = Statement.newBuilder((String)("SELECT key, val FROM " + this.tableName));
            this.addMaxKey(builder, maxKey, this.addMinKey(builder, minKey, false));
            builder.append(" ORDER BY key DESC");
            if (this.log.isTraceEnabled()) {
                this.log.trace("spanner: getRange():\n  minKey={}\n  maxKey={}\n  reverse={}\n  query={}", new Object[]{ByteUtil.toString((byte[])minKey), ByteUtil.toString((byte[])maxKey), reverse, builder.build()});
            }
            return new Iter(this.context.executeQuery(builder.build(), new Options.QueryOption[0]));
        }
        catch (SpannerException e) {
            throw this.exceptionMapper != null ? this.exceptionMapper.apply(e) : e;
        }
    }

    private ResultSet getPairs(byte[] minKey, byte[] maxKey, Options.ReadOption ... options) {
        Key min = Key.of((Object[])new Object[]{ByteArray.copyFrom((byte[])(minKey != null ? minKey : ByteUtil.EMPTY))});
        Key max = maxKey != null ? Key.of((Object[])new Object[]{ByteArray.copyFrom((byte[])maxKey)}) : TOP_KEY;
        return this.context.read(this.tableName, KeySet.range((KeyRange)KeyRange.closedOpen((Key)min, (Key)max)), KV_COL, options);
    }

    public void put(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("read-only view");
    }

    public void remove(byte[] key) {
        throw new UnsupportedOperationException("read-only view");
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        throw new UnsupportedOperationException("read-only view");
    }

    public void close() {
        block2: {
            try {
                this.context.close();
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("got exception close of " + this.context + " (ignoring)", (Throwable)e);
            }
        }
    }

    private boolean addMinKey(Statement.Builder builder, byte[] minKey, boolean where) {
        return this.addKey(builder, minKey, "minKey", ">=", where);
    }

    private boolean addMaxKey(Statement.Builder builder, byte[] maxKey, boolean where) {
        return this.addKey(builder, maxKey, "maxKey", "<", where);
    }

    private boolean addKey(Statement.Builder builder, byte[] key, String name, String op, boolean where) {
        if (key == null) {
            return where;
        }
        builder.append(where ? " AND " : " WHERE ").append("key ").append(op).append(" @").append(name).bind(name).to(ByteArray.copyFrom((byte[])key));
        return true;
    }

    protected static KVPair kv(Struct struct) {
        Preconditions.checkArgument((struct != null ? 1 : 0) != 0);
        return new KVPair(struct.getBytes(0).toByteArray(), struct.getBytes(1).toByteArray());
    }

    private class Iter
    implements CloseableIterator<KVPair> {
        private final ResultSet resultSet;
        private Struct next;

        Iter(ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        public boolean hasNext() {
            try {
                if (this.next != null) {
                    return true;
                }
                if (!this.resultSet.next()) {
                    return false;
                }
                this.next = this.resultSet.getCurrentRowAsStruct();
                return true;
            }
            catch (SpannerException e) {
                throw ReadOnlySpannerView.this.exceptionMapper != null ? ReadOnlySpannerView.this.exceptionMapper.apply(e) : e;
            }
        }

        public KVPair next() {
            if (this.next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            KVPair kv = ReadOnlySpannerView.kv(this.next);
            this.next = null;
            return kv;
        }

        public void remove() {
            throw new UnsupportedOperationException("read-only view");
        }

        public void close() {
            this.resultSet.close();
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

