/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.base.Preconditions;
import java.util.concurrent.Future;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.jsimpledb.kv.spanner.Access;
import org.jsimpledb.kv.spanner.ReadWriteSpannerView;
import org.jsimpledb.kv.spanner.SpannerKVDatabase;
import org.jsimpledb.kv.util.ForwardingKVStore;
import org.jsimpledb.util.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SpannerKVTransaction
extends ForwardingKVStore
implements KVTransaction {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final SpannerKVDatabase kvdb;
    protected final DatabaseClient client;
    protected final String tableName;
    protected final TimestampBound consistency;
    @GuardedBy(value="this")
    private boolean readOnly;
    @GuardedBy(value="this")
    private ReadContext context;
    @GuardedBy(value="this")
    private ReadWriteSpannerView view;
    @GuardedBy(value="this")
    private State state = State.INITIAL;

    protected SpannerKVTransaction(SpannerKVDatabase kvdb, DatabaseClient client, String tableName, TimestampBound consistency) {
        Preconditions.checkArgument((kvdb != null ? 1 : 0) != 0);
        Preconditions.checkArgument((client != null ? 1 : 0) != 0);
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((consistency != null ? 1 : 0) != 0);
        this.kvdb = kvdb;
        this.client = client;
        this.tableName = tableName;
        this.consistency = consistency;
        this.readOnly = !this.isStrongConsistency();
    }

    public synchronized TimestampBound getConsistency() {
        return this.consistency;
    }

    public synchronized boolean isStrongConsistency() {
        return this.consistency.getMode().equals((Object)TimestampBound.Mode.STRONG);
    }

    public synchronized Timestamp getTimestamp() {
        try {
            switch (this.state) {
                case INITIAL: {
                    throw new IllegalStateException("no data has been accessed yet");
                }
                case ACCESSED: {
                    if (!(this.context instanceof TransactionContext)) break;
                    throw new IllegalStateException("transaction is not committed yet");
                }
            }
            if (this.context instanceof TransactionContext) {
                return (Timestamp)Access.invoke(Access.TRANSACTION_CONTEXT_COMMIT_TIMESTAMP_METHOD, this.context, new Object[0]);
            }
            if (this.context instanceof ReadOnlyTransaction) {
                return ((ReadOnlyTransaction)this.context).getReadTimestamp();
            }
            return null;
        }
        catch (SpannerException e) {
            throw this.wrapException(e);
        }
    }

    public SpannerKVDatabase getKVDatabase() {
        return this.kvdb;
    }

    public void setTimeout(long timeout) {
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized void setReadOnly(boolean readOnly) {
        Preconditions.checkState((this.state == State.INITIAL || readOnly == this.readOnly ? 1 : 0) != 0, (Object)"data already accessed");
        Preconditions.checkArgument((this.isStrongConsistency() || readOnly ? 1 : 0) != 0, (Object)"strong consistency is required for read-write transactions");
        this.readOnly = readOnly;
    }

    public synchronized void commit() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("commit() invoked: state=" + (Object)((Object)this.state) + " view=" + (Object)((Object)this.view));
        }
        switch (this.state) {
            case INITIAL: {
                assert (this.view == null);
                assert (this.context == null);
                this.state = State.CLOSED;
                return;
            }
            case ACCESSED: {
                break;
            }
            default: {
                throw new StaleTransactionException((KVTransaction)this);
            }
        }
        try {
            if (this.context instanceof TransactionContext) {
                this.view.bufferMutations((TransactionContext)this.context);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("committing transaction " + this.context);
                }
                Access.invoke(Access.TRANSACTION_CONTEXT_COMMIT_METHOD, this.context, new Object[0]);
            }
        }
        catch (SpannerException e) {
            throw this.wrapException(e);
        }
        finally {
            this.cleanupAccessed();
        }
    }

    public synchronized void rollback() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("rollback() invoked: state=" + (Object)((Object)this.state) + " view=" + (Object)((Object)this.view));
        }
        switch (this.state) {
            case INITIAL: {
                assert (this.view == null);
                assert (this.context == null);
                this.state = State.CLOSED;
                return;
            }
            case ACCESSED: {
                break;
            }
            default: {
                return;
            }
        }
        try {
            if (this.context instanceof TransactionContext) {
                Access.invoke(Access.TRANSACTION_CONTEXT_ROLLBACK_METHOD, this.context, new Object[0]);
            }
        }
        catch (SpannerException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("got exception during rollback (ignoring)", (Throwable)e);
            }
        }
        finally {
            this.cleanupAccessed();
        }
    }

    private void cleanupAccessed() {
        assert (Thread.holdsLock((Object)this));
        assert (State.ACCESSED.equals((Object)this.state));
        this.kvdb.updateRttEstimate(this.view.getRttEstimate());
        try {
            this.view.close();
        }
        finally {
            this.view = null;
            this.context = null;
            this.state = State.CLOSED;
        }
    }

    public Future<Void> watchKey(byte[] key) {
        throw new UnsupportedOperationException();
    }

    public CloseableKVStore mutableSnapshot() {
        throw new UnsupportedOperationException();
    }

    public byte[] get(byte[] key) {
        try {
            return super.get(key);
        }
        catch (SpannerException e) {
            this.rollback();
            throw this.wrapException(e);
        }
    }

    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        try {
            return super.getAtLeast(minKey, maxKey);
        }
        catch (SpannerException e) {
            this.rollback();
            throw this.wrapException(e);
        }
    }

    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        try {
            return super.getAtMost(maxKey, minKey);
        }
        catch (SpannerException e) {
            this.rollback();
            throw this.wrapException(e);
        }
    }

    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        try {
            return super.getRange(minKey, maxKey, reverse);
        }
        catch (SpannerException e) {
            this.rollback();
            throw this.wrapException(e);
        }
    }

    protected synchronized KVStore delegate() {
        switch (this.state) {
            case INITIAL: {
                assert (this.view == null);
                assert (this.context == null);
                break;
            }
            case ACCESSED: {
                assert (this.view != null);
                assert (this.context != null);
                return this.view;
            }
            default: {
                assert (this.view == null);
                assert (this.context == null);
                throw new StaleTransactionException((KVTransaction)this);
            }
        }
        Object object = this.context = this.readOnly ? this.client.readOnlyTransaction(this.consistency) : this.readWriteTransaction();
        if (this.log.isTraceEnabled()) {
            this.log.trace("creating delegate: context=" + this.context);
        }
        this.view = new ReadWriteSpannerView(this.tableName, this.context, this::wrapException, this.kvdb.getExecutorService(), (long)this.kvdb.getRttEstimate());
        this.state = State.ACCESSED;
        return this.view;
    }

    protected RuntimeException wrapException(SpannerException e) {
        return e.isRetryable() || e instanceof AbortedException ? new RetryTransactionException((KVTransaction)this, e.getMessage(), (Throwable)e) : new KVTransactionException((KVTransaction)this, e.getMessage(), (Throwable)e);
    }

    private TransactionContext readWriteTransaction() {
        TransactionRunner runner1 = this.client.readWriteTransaction();
        TransactionRunner runner2 = (TransactionRunner)Access.read(Access.POOLED_SESSION_1_RUNNER_FIELD, runner1);
        TransactionContext context1 = (TransactionContext)Access.read(Access.TRANSACTION_RUNNER_TXN_FIELD, runner2);
        Access.invoke(Access.TRANSACTION_CONTEXT_ENSURE_TXN_METHOD, context1, new Object[0]);
        return context1;
    }

    private static enum State {
        INITIAL,
        ACCESSED,
        CLOSED;

    }
}

