/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.gax.core.ApiClock;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.common.base.Preconditions;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;

public class ExponentialRetryAlgorithm
implements TimedRetryAlgorithm {
    private final RetrySettings globalSettings;
    private final ApiClock clock;

    public ExponentialRetryAlgorithm(RetrySettings globalSettings, ApiClock clock) {
        this.globalSettings = (RetrySettings)Preconditions.checkNotNull((Object)globalSettings);
        this.clock = (ApiClock)Preconditions.checkNotNull((Object)clock);
    }

    @Override
    public TimedAttemptSettings createFirstAttempt() {
        return new TimedAttemptSettings(this.globalSettings, Duration.ZERO, this.globalSettings.getTotalTimeout(), Duration.ZERO, 0, this.clock.nanoTime());
    }

    @Override
    public TimedAttemptSettings createNextAttempt(TimedAttemptSettings prevSettings) {
        RetrySettings settings = prevSettings.getGlobalSettings();
        long newRetryDelay = settings.getInitialRetryDelay().getMillis();
        long newRpcTimeout = settings.getInitialRpcTimeout().getMillis();
        if (prevSettings.getAttemptCount() > 0) {
            newRetryDelay = (long)(settings.getRetryDelayMultiplier() * (double)prevSettings.getRetryDelay().getMillis());
            newRetryDelay = Math.min(newRetryDelay, settings.getMaxRetryDelay().getMillis());
            newRpcTimeout = (long)(settings.getRpcTimeoutMultiplier() * (double)prevSettings.getRpcTimeout().getMillis());
            newRpcTimeout = Math.min(newRpcTimeout, settings.getMaxRpcTimeout().getMillis());
        }
        return new TimedAttemptSettings(prevSettings.getGlobalSettings(), Duration.millis((long)newRetryDelay), Duration.millis((long)newRpcTimeout), Duration.millis((long)ThreadLocalRandom.current().nextLong(newRetryDelay)), prevSettings.getAttemptCount() + 1, prevSettings.getFirstAttemptStartTime());
    }

    @Override
    public boolean accept(TimedAttemptSettings nextAttemptSettings) {
        long totalTimeoutMillis;
        long totalTimeoutNanos;
        RetrySettings globalSettings = nextAttemptSettings.getGlobalSettings();
        long randRetryDelayMillis = nextAttemptSettings.getRandomizedRetryDelay().getMillis();
        long totalTimeSpentNanos = this.clock.nanoTime() - nextAttemptSettings.getFirstAttemptStartTime() + TimeUnit.NANOSECONDS.convert(randRetryDelayMillis, TimeUnit.MILLISECONDS);
        return totalTimeSpentNanos <= (totalTimeoutNanos = TimeUnit.NANOSECONDS.convert(totalTimeoutMillis = globalSettings.getTotalTimeout().getMillis(), TimeUnit.MILLISECONDS)) && (globalSettings.getMaxAttempts() <= 0 || nextAttemptSettings.getAttemptCount() < globalSettings.getMaxAttempts());
    }
}

