/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public class ByteBufferInputStream
extends InputStream {
    protected final ByteBuffer buf;
    private boolean closed;

    public ByteBufferInputStream(ByteBuffer buf) {
        if (buf == null) {
            throw new IllegalArgumentException("null buf");
        }
        this.buf = buf;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public synchronized int read(byte[] data, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buf.remaining());
        this.buf.get(data, off, len);
        return len;
    }

    @Override
    public synchronized long skip(long amount) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        int skip = (int)Math.min(amount, (long)this.buf.remaining());
        if (skip <= 0) {
            return 0L;
        }
        this.buf.position(this.buf.position() + skip);
        return skip;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        return this.buf.remaining();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.closed) {
            return;
        }
        this.buf.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        try {
            this.buf.reset();
        }
        catch (InvalidMarkException e) {
            throw new IOException("no mark set", e);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }
}

