/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.dellroad.stuff.io.ReadCallback;

public class NullModemOutputStream
extends FilterOutputStream {
    public NullModemOutputStream(ReadCallback reader, String name) {
        super(new PipedOutputStream());
        PipedInputStream input;
        if (reader == null) {
            throw new IllegalArgumentException("null reader");
        }
        try {
            input = new PipedInputStream(this.getPipedOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        ReaderThread thread = new ReaderThread(reader, input, name);
        thread.setDaemon(true);
        thread.start();
    }

    protected PipedOutputStream getPipedOutputStream() {
        return (PipedOutputStream)this.out;
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.getPipedOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    private static class ReaderThread
    extends Thread {
        private final ReadCallback reader;
        private final PipedInputStream input;

        ReaderThread(ReadCallback reader, PipedInputStream input, String name) {
            super(name);
            this.reader = reader;
            this.input = input;
        }

        @Override
        public void run() {
            try {
                this.reader.readFrom(this.input);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

