/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.dellroad.stuff.java.Primitive;

public class MethodAnnotationScanner<T, A extends Annotation> {
    protected final Class<T> type;
    protected final Class<A> annotationType;

    public MethodAnnotationScanner(Class<T> type, Class<A> annotationType) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        if (annotationType == null) {
            throw new IllegalArgumentException("null annotationType");
        }
        this.type = type;
        this.annotationType = annotationType;
    }

    public Set<MethodInfo> findAnnotatedMethods() {
        HashSet<MethodInfo> set = new HashSet<MethodInfo>();
        this.findMethodInfos(this.type, set);
        LinkedHashMap nameSetMap = new LinkedHashMap();
        block0: for (MethodInfo methodInfo : set) {
            String name = methodInfo.getMethod().getName();
            Method method = methodInfo.getMethod();
            HashSet<MethodInfo> nameSet = (HashSet<MethodInfo>)nameSetMap.get(name);
            if (nameSet == null) {
                nameSet = new HashSet<MethodInfo>();
                nameSetMap.put(name, nameSet);
                nameSet.add(methodInfo);
                continue;
            }
            Iterator i = nameSet.iterator();
            while (i.hasNext()) {
                Method otherMethod = ((MethodInfo)i.next()).getMethod();
                if (MethodAnnotationScanner.overrides(method, otherMethod)) {
                    i.remove();
                    continue;
                }
                if (!MethodAnnotationScanner.overrides(otherMethod, method)) continue;
                continue block0;
            }
            nameSet.add(methodInfo);
        }
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        for (HashSet nameSet : nameSetMap.values()) {
            result.addAll(nameSet);
        }
        return result;
    }

    protected void findMethodInfos(Class<?> klass, Set<MethodInfo> set) {
        if (klass == null) {
            return;
        }
        for (Method method : klass.getDeclaredMethods()) {
            MethodInfo methodInfo;
            A annotation = this.getAnnotation(method);
            if (annotation == null || !this.includeMethod(method, annotation) || (methodInfo = this.createMethodInfo(method, annotation)) == null) continue;
            set.add(methodInfo);
        }
        for (GenericDeclaration genericDeclaration : klass.getInterfaces()) {
            this.findMethodInfos((Class<?>)genericDeclaration, set);
        }
        this.findMethodInfos(klass.getSuperclass(), set);
    }

    protected A getAnnotation(Method method) {
        return method.getAnnotation(this.annotationType);
    }

    protected boolean includeMethod(Method method, A annotation) {
        return method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0;
    }

    public static boolean overrides(Method override, Method original) {
        Class<?> overrideReturnType;
        Class<?> originalReturnType;
        if (!original.getDeclaringClass().isAssignableFrom(override.getDeclaringClass())) {
            return false;
        }
        if (!(original.getDeclaringClass() != override.getDeclaringClass() || (originalReturnType = original.getReturnType()).isAssignableFrom(overrideReturnType = override.getReturnType()) && originalReturnType != overrideReturnType)) {
            return false;
        }
        if (!original.getName().equals(override.getName())) {
            return false;
        }
        if ((original.getModifiers() & 8) != 0 || (override.getModifiers() & 8) != 0) {
            return false;
        }
        return Arrays.equals(original.getParameterTypes(), override.getParameterTypes());
    }

    protected MethodInfo createMethodInfo(Method method, A annotation) {
        return new MethodInfo(this, method, annotation);
    }

    public static class MethodInfo {
        private final Method method;
        private final A annotation;
        final /* synthetic */ MethodAnnotationScanner this$0;

        public MethodInfo(Method method, A annotation) {
            this.this$0 = this$0;
            if (method == null) {
                throw new IllegalArgumentException("null method");
            }
            if (annotation == null) {
                throw new IllegalArgumentException("null annotation");
            }
            this.method = method;
            this.annotation = annotation;
            try {
                this.method.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        public Method getMethod() {
            return this.method;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public String getMethodPropertyName() {
            String name = this.method.getName();
            if (name.startsWith("get") && name.length() > 3) {
                return Introspector.decapitalize(name.substring(3));
            }
            if (name.startsWith("is") && name.length() > 2 && Primitive.get(this.method.getReturnType()) == Primitive.BOOLEAN) {
                return Introspector.decapitalize(name.substring(2));
            }
            throw new IllegalArgumentException("can't infer property name from non-Java bean method " + this.method);
        }

        public Object invoke(T obj, Object ... params) {
            try {
                return this.method.invoke(obj, params);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Method getSetter() {
            String getterName = this.method.getName();
            if (getterName.matches("^(is|get).+$")) {
                String setterName = "set" + getterName.substring(getterName.startsWith("is") ? 2 : 3);
                try {
                    return this.method.getDeclaringClass().getMethod(setterName, this.method.getReturnType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MethodInfo that = (MethodInfo)obj;
            return this.method.equals(that.method) && this.annotation.equals(that.annotation);
        }

        public int hashCode() {
            return this.method.hashCode() ^ this.annotation.hashCode();
        }
    }
}

