/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;

public class SerializableMethod
implements Serializable {
    private static final long serialVersionUID = 3761038535500978361L;
    private transient Method method;

    public SerializableMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return this.method.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SerializableMethod that = (SerializableMethod)obj;
        return this.method.equals(that.method);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.method.getDeclaringClass());
        out.writeUTF(this.method.getName());
        out.writeObject(this.method.getParameterTypes());
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        Class cl = (Class)input.readObject();
        String name = input.readUTF();
        Class[] ptypes = (Class[])input.readObject();
        try {
            this.method = cl.getMethod(name, ptypes);
        }
        catch (Exception e) {
            throw new IOException("can't find method " + cl.getName() + "." + name + "()");
        }
    }
}

