/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.dellroad.stuff.net.ChannelConnection;
import org.dellroad.stuff.net.Network;
import org.dellroad.stuff.net.SelectorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelNetwork
extends SelectorSupport
implements Network {
    public static final int DEFAULT_MAX_CONNECTIONS = 1000;
    public static final long DEFAULT_MAX_IDLE_TIME = 30000L;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x2000000;
    public static final long DEFAULT_MAX_OUTPUT_QUEUE_SIZE = 0x4000000L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final HashMap<String, ChannelConnection> connectionMap = new HashMap();
    protected Network.Handler handler;
    protected ExecutorService executor;
    private int maxConnections = 1000;
    private long maxIdleTime = 30000L;
    private int maxMessageSize = 0x2000000;
    private long maxOutputQueueSize = 0x4000000L;
    private String serviceThreadName;

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public synchronized long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public synchronized void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public synchronized int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public synchronized void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public synchronized long getMaxOutputQueueSize() {
        return this.maxOutputQueueSize;
    }

    public synchronized void setMaxOutputQueueSize(long maxOutputQueueSize) {
        this.maxOutputQueueSize = maxOutputQueueSize;
    }

    public synchronized String getServiceThreadName() {
        return this.serviceThreadName;
    }

    public synchronized void setServiceThreadName(String serviceThreadName) {
        this.serviceThreadName = serviceThreadName;
    }

    @Override
    public synchronized void start(Network.Handler handler) throws IOException {
        super.start();
        boolean successful = false;
        try {
            if (this.handler != null) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("starting " + this);
            }
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    ChannelNetwork channelNetwork = ChannelNetwork.this;
                    synchronized (channelNetwork) {
                        if (ChannelNetwork.this.serviceThreadName != null) {
                            thread.setName(ChannelNetwork.this.serviceThreadName);
                        }
                    }
                    return thread;
                }
            });
            this.handler = handler;
            successful = true;
        }
        finally {
            if (!successful) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        ChannelNetwork channelNetwork = this;
        synchronized (channelNetwork) {
            if (this.handler == null) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopping " + this);
            }
            if (this.executor != null) {
                this.executor.shutdownNow();
                try {
                    this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.executor = null;
            }
            this.handler = null;
        }
    }

    @Override
    public synchronized boolean send(String peer, ByteBuffer msg) {
        if (peer == null) {
            throw new IllegalArgumentException("null peer");
        }
        String normalizedPeer = this.normalizePeerName(peer);
        ChannelConnection connection = this.connectionMap.get(normalizedPeer);
        if (connection == null) {
            try {
                connection = this.createConnection(peer);
            }
            catch (IOException e) {
                this.log.info(this + " unable to send message to `" + peer + "': " + e.getMessage());
                return false;
            }
            this.connectionMap.put(normalizedPeer, connection);
        }
        return connection.output(msg);
    }

    void handleMessage(final ChannelConnection connection, final ByteBuffer msg) {
        assert (Thread.holdsLock(this));
        assert (this.isServiceThread());
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ChannelNetwork.this.handler.handle(connection.getPeer(), msg);
                }
                catch (Throwable t) {
                    ChannelNetwork.this.log.error("exception in callback", t);
                }
            }
        });
    }

    void handleOutputQueueEmpty(final ChannelConnection connection) {
        assert (Thread.holdsLock(this));
        assert (this.isServiceThread());
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ChannelNetwork.this.handler.outputQueueEmpty(connection.getPeer());
                }
                catch (Throwable t) {
                    ChannelNetwork.this.log.error("exception in callback", t);
                }
            }
        });
    }

    void handleConnectionClosed(ChannelConnection connection) {
        assert (Thread.holdsLock(this));
        assert (this.isServiceThread());
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + " handling closed connection " + connection);
        }
        String normalizedPeer = this.normalizePeerName(connection.getPeer());
        this.connectionMap.remove(normalizedPeer);
        this.handleOutputQueueEmpty(connection);
        this.wakeup();
    }

    protected String normalizePeerName(String peer) {
        return peer;
    }

    protected abstract ChannelConnection createConnection(String var1) throws IOException;

    @Override
    protected void serviceHousekeeping() {
        for (ChannelConnection connection : new ArrayList<ChannelConnection>(this.connectionMap.values())) {
            try {
                connection.performHousekeeping();
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("I/O error from " + connection, (Throwable)e);
                }
                connection.close(e);
            }
            catch (Throwable t) {
                this.log.error("error performing housekeeping for " + connection, t);
                connection.close(t);
            }
        }
    }

    @Override
    protected void serviceCleanup() {
        for (ChannelConnection connection : new ArrayList<ChannelConnection>(this.connectionMap.values())) {
            connection.close(null);
        }
    }
}

