/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.schema;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.dellroad.stuff.schema.AbstractSchemaUpdater;
import org.dellroad.stuff.schema.DatabaseAction;
import org.dellroad.stuff.schema.SQLCommand;
import org.dellroad.stuff.schema.SQLCommandList;

public class SQLSchemaUpdater
extends AbstractSchemaUpdater<DataSource, Connection> {
    public static final String DEFAULT_UPDATE_TABLE_NAME = "SchemaUpdate";
    public static final String DEFAULT_UPDATE_TABLE_NAME_COLUMN = "updateName";
    public static final String DEFAULT_UPDATE_TABLE_TIME_COLUMN = "updateTime";
    private String updateTableName = "SchemaUpdate";
    private String updateTableNameColumn = "updateName";
    private String updateTableTimeColumn = "updateTime";
    private SQLCommandList databaseInitialization;
    private SQLCommandList updateTableInitialization;

    public String getUpdateTableName() {
        return this.updateTableName;
    }

    public void setUpdateTableName(String updateTableName) {
        this.updateTableName = updateTableName;
    }

    public String getUpdateTableNameColumn() {
        return this.updateTableNameColumn;
    }

    public void setUpdateTableNameColumn(String updateTableNameColumn) {
        this.updateTableNameColumn = updateTableNameColumn;
    }

    public String getUpdateTableTimeColumn() {
        return this.updateTableTimeColumn;
    }

    public void setUpdateTableTimeColumn(String updateTableTimeColumn) {
        this.updateTableTimeColumn = updateTableTimeColumn;
    }

    public SQLCommandList getUpdateTableInitialization() {
        return this.updateTableInitialization;
    }

    public void setUpdateTableInitialization(SQLCommandList updateTableInitialization) {
        this.updateTableInitialization = updateTableInitialization;
    }

    public SQLCommandList getDatabaseInitialization() {
        return this.databaseInitialization;
    }

    public void setDatabaseInitialization(SQLCommandList databaseInitialization) {
        this.databaseInitialization = databaseInitialization;
    }

    @Override
    protected void apply(Connection c, DatabaseAction<Connection> action) throws SQLException {
        try {
            super.apply(c, action);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void initializeAndUpdateDatabase(DataSource dataSource) throws SQLException {
        try {
            super.initializeAndUpdateDatabase(dataSource);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Connection openTransaction(DataSource dataSource) throws SQLException {
        Connection c = dataSource.getConnection();
        c.setTransactionIsolation(8);
        c.setAutoCommit(false);
        return c;
    }

    @Override
    protected void commitTransaction(Connection c) throws SQLException {
        c.commit();
        c.close();
    }

    @Override
    protected void rollbackTransaction(Connection c) throws SQLException {
        c.rollback();
        c.close();
    }

    @Override
    protected boolean databaseNeedsInitialization(Connection c) throws SQLException {
        final boolean[] result = new boolean[1];
        this.apply(c, (DatabaseAction<Connection>)new SQLCommand("SELECT COUNT(*) FROM " + this.getUpdateTableName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply(Connection c) throws SQLException {
                ResultSet resultSet;
                try (Statement s = c.createStatement();){
                    try {
                        resultSet = s.executeQuery(this.getSQL());
                    }
                    catch (SQLException e) {
                        if (SQLSchemaUpdater.this.indicatesUninitializedDatabase(c, e)) {
                            SQLSchemaUpdater.this.log.info("detected an uninitialized database");
                            result[0] = true;
                            s.close();
                            return;
                        }
                        throw e;
                    }
                    if (!resultSet.next()) {
                        throw new IllegalStateException("zero rows returned by `" + this.getSQL() + "'");
                    }
                }
                SQLSchemaUpdater.this.log.info("detected initialized database, with " + resultSet.getLong(1) + " update(s) already applied");
            }
        });
        return result[0];
    }

    protected boolean indicatesUninitializedDatabase(Connection c, SQLException e) throws SQLException {
        return true;
    }

    @Override
    protected void recordUpdateApplied(Connection c, final String updateName) throws SQLException {
        this.apply(c, (DatabaseAction<Connection>)new SQLCommand("INSERT INTO " + this.getUpdateTableName() + " (" + this.getUpdateTableNameColumn() + ", " + this.getUpdateTableTimeColumn() + ") VALUES (?, ?)"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply(Connection c) throws SQLException {
                try (PreparedStatement s = c.prepareStatement(this.getSQL());){
                    s.setString(1, updateName);
                    s.setDate(2, new java.sql.Date(new Date().getTime()));
                    int rows = s.executeUpdate();
                    if (rows != 1) {
                        throw new IllegalStateException("got " + rows + " != 1 rows for `" + this.getSQL() + "'");
                    }
                }
            }
        });
    }

    @Override
    protected Set<String> getAppliedUpdateNames(Connection c) throws SQLException {
        final HashSet<String> updateNames = new HashSet<String>();
        this.apply(c, (DatabaseAction<Connection>)new SQLCommand("SELECT " + this.getUpdateTableNameColumn() + " FROM " + this.getUpdateTableName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply(Connection c) throws SQLException {
                try (Statement s = c.createStatement();){
                    ResultSet resultSet = s.executeQuery(this.getSQL());
                    while (resultSet.next()) {
                        updateNames.add(resultSet.getString(1));
                    }
                }
            }
        });
        return updateNames;
    }

    @Override
    protected void initializeDatabase(Connection c) throws SQLException {
        if (this.getDatabaseInitialization() == null) {
            throw new IllegalArgumentException("database needs initialization but no database initialization is configured");
        }
        if (this.getUpdateTableInitialization() == null) {
            throw new IllegalArgumentException("database needs initialization but no update table initialization is configured");
        }
        this.log.info("intializing database schema");
        this.apply(c, (DatabaseAction<Connection>)this.getDatabaseInitialization());
        this.log.info("intializing update table");
        this.apply(c, (DatabaseAction<Connection>)this.getUpdateTableInitialization());
    }
}

