/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.string;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dellroad.stuff.string.VersionPartComparator;

public class VersionComparator
implements Comparator<String> {
    private static final Pattern PART_PATTERN = Pattern.compile("[0-9]+|[^0-9.]+|\\.");
    private final Comparator<String> partComparator;

    public VersionComparator(Comparator<String> partComparator) {
        if (partComparator == null) {
            throw new IllegalArgumentException("null partComparator");
        }
        this.partComparator = partComparator;
    }

    public VersionComparator() {
        this(new VersionPartComparator());
    }

    @Override
    public int compare(String v1, String v2) {
        ArrayList<List<String>> partsList = new ArrayList<List<String>>(2);
        partsList.add(this.separateIntoParts(v1));
        partsList.add(this.separateIntoParts(v2));
        int i = 0;
        while (true) {
            String part2;
            boolean hasPart2;
            boolean hasPart1 = i < ((List)partsList.get(0)).size();
            boolean bl = hasPart2 = i < ((List)partsList.get(1)).size();
            if (!hasPart1 && !hasPart2) {
                return 0;
            }
            if (hasPart1 && !hasPart2) {
                return 1;
            }
            if (!hasPart1 && hasPart2) {
                return -1;
            }
            String part1 = (String)((List)partsList.get(0)).get(i);
            int diff = this.partComparator.compare(part1, part2 = (String)((List)partsList.get(1)).get(i));
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
    }

    protected List<String> separateIntoParts(String version) {
        ArrayList<String> partsList = new ArrayList<String>();
        int pos = 0;
        Matcher matcher = PART_PATTERN.matcher(version);
        while (matcher.find(pos)) {
            String part = matcher.group();
            if (!part.equals(".")) {
                partsList.add(part);
            } else if (matcher.end() == version.length() || version.charAt(matcher.end()) == '.') {
                partsList.add("");
            }
            pos = matcher.end();
        }
        return partsList;
    }
}

