/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import org.dellroad.stuff.util.LongMap;

public class LongSet
extends AbstractSet<Long>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8245070561628904936L;
    private LongMap<?> map;

    public LongSet() {
        this(0);
    }

    public LongSet(int capacity) {
        this(new LongMap(capacity, false));
    }

    public LongSet(Iterable<? extends Number> values) {
        this(0);
        if (values == null) {
            throw new IllegalArgumentException("null values");
        }
        for (Number number : values) {
            if (number == null) {
                throw new IllegalArgumentException("null value");
            }
            this.add(number.longValue());
        }
    }

    public LongSet(long[] values) {
        this(0);
        if (values == null) {
            throw new IllegalArgumentException("null values");
        }
        for (long value : values) {
            this.add(value);
        }
    }

    LongSet(LongMap<?> map) {
        this.map = map;
    }

    public long removeOne() {
        Map.Entry<Long, ?> entry = this.map.removeOne();
        return entry != null ? entry.getKey() : 0L;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private final LongMap.EntrySetIterator entryIterator;
            {
                this.entryIterator = LongSet.this.map.new LongMap.EntrySetIterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public Long next() {
                return this.entryIterator.next().getKey();
            }

            @Override
            public void remove() {
                this.entryIterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    public boolean contains(long value) {
        return this.map.containsKey(value);
    }

    @Override
    public boolean add(Long value) {
        return this.add((long)value);
    }

    @Override
    public boolean add(long value) {
        if (this.map.containsKey(value)) {
            return false;
        }
        this.map.put(value, null);
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        if (!this.map.containsKey(obj)) {
            return false;
        }
        this.map.remove(obj);
        return true;
    }

    public boolean remove(long value) {
        if (!this.map.containsKey(value)) {
            return false;
        }
        this.map.remove(value);
        return true;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Long[] toArray() {
        return this.map.toKeysArray();
    }

    public long[] toLongArray() {
        return this.map.toKeysLongArray();
    }

    String debugDump() {
        return this.map.debugDump();
    }

    @Override
    public int hashCode() {
        long[] keyArray = this.map.getKeys();
        int hash = 0;
        for (int i = 0; i < keyArray.length; ++i) {
            long key = keyArray[i];
            if (key == 0L) continue;
            hash += (int)(key >>> 32) ^ (int)key;
        }
        return hash;
    }

    public LongSet clone() {
        LongSet clone;
        try {
            clone = (LongSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.map = clone.map.clone();
        return clone;
    }
}

