/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.dellroad.stuff.validation.AbstractValidator;
import org.dellroad.stuff.validation.Sorted;

public class SortedValidator
extends AbstractValidator<Sorted, Object> {
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        Comparator comparator;
        Collection<Object> iterable;
        if (value == null) {
            return true;
        }
        if (value instanceof Object[]) {
            iterable = Arrays.asList((Object[])value);
        } else if (value instanceof Collection) {
            iterable = (Collection)value;
        } else if (value instanceof Map) {
            iterable = ((Map)value).keySet();
        } else {
            this.setViolation(context, "@Sorted constraint only applies to non-primitive arrays, collections and maps");
            return false;
        }
        if (((Sorted)this.annotation).comparator() == Comparator.class) {
            comparator = new Comparator(){

                public int compare(Object x, Object y) {
                    return ((Comparable)x).compareTo(y);
                }
            };
        } else {
            try {
                comparator = ((Sorted)this.annotation).comparator().newInstance();
            }
            catch (Exception e) {
                this.setViolation(context, "Cannot instantiate comparator for @Sorted constraint: " + e);
                return false;
            }
        }
        Object prev = null;
        int index = -1;
        for (Object t : iterable) {
            int diff;
            ++index;
            if (prev == null) {
                prev = t;
                continue;
            }
            if (t == null) continue;
            try {
                diff = comparator.compare(prev, t);
            }
            catch (ClassCastException e) {
                this.setViolation(context, "@Sorted constraint only applies to Comparable elements: " + e);
                return false;
            }
            if (diff <= 0 && (!((Sorted)this.annotation).strict() || diff != 0)) continue;
            this.setViolation(context, "elements are not properly sorted (mis-ordered at index " + index + ")");
            return false;
        }
        return true;
    }
}

