/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.caching;

import com.google.common.base.Preconditions;

public interface CachingConfig {
    public static final int DEFAULT_MAX_RANGES = 256;
    public static final long DEFAULT_MAX_RANGE_BYTES = 0xA00000L;
    public static final long DEFAULT_MAX_TOTAL_BYTES = 0x6400000L;
    public static final boolean DEFAULT_READ_AHEAD = true;

    public long getMaxRangeBytes();

    public void setMaxRangeBytes(long var1);

    public long getMaxTotalBytes();

    public void setMaxTotalBytes(long var1);

    public int getMaxRanges();

    public void setMaxRanges(int var1);

    public boolean isReadAhead();

    public void setReadAhead(boolean var1);

    default public void copyCachingConfigTo(CachingConfig dest) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0);
        dest.setMaxRangeBytes(this.getMaxRangeBytes());
        dest.setMaxTotalBytes(this.getMaxTotalBytes());
        dest.setMaxRanges(this.getMaxRanges());
        dest.setReadAhead(this.isReadAhead());
    }
}

