/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.caching;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.caching.AbstractCachingConfig;
import org.jsimpledb.kv.caching.CachingKVTransaction;
import org.jsimpledb.util.MovingAverage;

public class CachingKVDatabase
extends AbstractCachingConfig
implements KVDatabase {
    public static final int DEFAULT_INITIAL_RTT_ESTIMATE_MILLIS = 50;
    public static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final double RTT_ESTIMATE_DECAY_FACTOR = 0.025;
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private KVDatabase inner;
    private int threadPoolSize = 10;
    private long initialRttEstimate = TimeUnit.MILLISECONDS.toNanos(50L);
    private ExecutorService executor;
    private boolean started;
    private boolean privateExecutor;
    private MovingAverage rtt;

    public CachingKVDatabase() {
    }

    public CachingKVDatabase(KVDatabase inner) {
        this.inner = inner;
    }

    public synchronized long getInitialRttEstimate() {
        return this.initialRttEstimate;
    }

    public synchronized void setInitialRttEstimate(long initialRttEstimate) {
        Preconditions.checkArgument((initialRttEstimate >= 0L ? 1 : 0) != 0, (Object)"initialRttEstimate < 0");
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.initialRttEstimate = initialRttEstimate;
    }

    public synchronized KVDatabase getKVDatabase() {
        return this.inner;
    }

    public synchronized void setKVDatabase(KVDatabase inner) {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.inner = inner;
    }

    public synchronized ExecutorService getExecutorService() {
        return this.executor;
    }

    public synchronized void setExecutorService(ExecutorService executor) {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.executor = executor;
    }

    public synchronized int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public synchronized void setThreadPoolSize(int threadPoolSize) {
        Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize <= 0");
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.threadPoolSize = threadPoolSize;
    }

    @PostConstruct
    public synchronized void start() {
        Preconditions.checkState((this.inner != null ? 1 : 0) != 0, (Object)"no inner KVDatabase configured");
        if (this.started) {
            return;
        }
        boolean bl = this.privateExecutor = this.executor == null;
        if (this.privateExecutor) {
            this.executor = Executors.newFixedThreadPool(this.threadPoolSize, r -> {
                Thread thread = new Thread(r);
                thread.setName(this.getClass().getSimpleName() + "-" + THREAD_COUNTER.incrementAndGet());
                return thread;
            });
        }
        this.rtt = new MovingAverage(0.025, (double)this.initialRttEstimate);
        try {
            this.inner.start();
            this.started = true;
        }
        finally {
            if (!this.started) {
                this.shutdown();
            }
        }
    }

    @PreDestroy
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.shutdown();
        this.started = false;
    }

    private synchronized void shutdown() {
        if (this.executor != null) {
            if (this.privateExecutor) {
                this.executor.shutdown();
            }
            this.executor = null;
        }
        this.inner.stop();
    }

    public CachingKVTransaction createTransaction() {
        return this.createTransaction(() -> ((KVDatabase)this.inner).createTransaction());
    }

    public CachingKVTransaction createTransaction(Map<String, ?> options) {
        return this.createTransaction(() -> this.inner.createTransaction(options));
    }

    protected synchronized CachingKVTransaction createTransaction(Supplier<? extends KVTransaction> innerTxCreator) {
        Preconditions.checkState((boolean)this.started, (Object)"not started");
        return new CachingKVTransaction(this, innerTxCreator.get(), this.executor, (long)this.rtt.get());
    }

    public synchronized double getRttEstimate() {
        Preconditions.checkState((this.rtt != null ? 1 : 0) != 0, (Object)"instance has never started");
        return this.rtt.get();
    }

    synchronized void updateRttEstimate(double rtt) {
        this.rtt.add(rtt);
    }
}

