/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.caching;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.caching.AbstractCachingConfig;
import org.jsimpledb.kv.caching.CachingKVDatabase;
import org.jsimpledb.kv.caching.CachingKVStore;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.util.CloseableIterator;

public class CachingKVTransaction
extends AbstractCachingConfig
implements KVTransaction,
CloseableKVStore {
    protected final CachingKVDatabase kvdb;
    protected final MutableView view;
    protected final CachingKVStore cachingKV;
    protected final KVTransaction inner;

    CachingKVTransaction(CachingKVDatabase kvdb, KVTransaction inner, ExecutorService executor, long rttEstimate) {
        this.kvdb = kvdb;
        this.inner = inner;
        this.cachingKV = new CachingKVStore((KVStore)inner, executor, rttEstimate);
        this.kvdb.copyCachingConfigTo(this.cachingKV);
        this.view = new MutableView((KVStore)this.cachingKV);
        this.view.disableReadTracking();
    }

    public KVTransaction getInnerTransaction() {
        return this.inner;
    }

    public CachingKVStore getCachingKVStore() {
        return this.cachingKV;
    }

    public void close() {
        this.kvdb.updateRttEstimate(this.cachingKV.getRttEstimate());
        this.cachingKV.close();
        this.inner.rollback();
    }

    public byte[] get(byte[] key) {
        return this.view.get(key);
    }

    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        return this.view.getAtLeast(minKey, maxKey);
    }

    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        return this.view.getAtMost(maxKey, minKey);
    }

    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        return this.view.getRange(minKey, maxKey, reverse);
    }

    public void put(byte[] key, byte[] value) {
        this.view.put(key, value);
    }

    public void remove(byte[] key) {
        this.view.remove(key);
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        this.view.removeRange(minKey, maxKey);
    }

    public void adjustCounter(byte[] key, long amount) {
        this.view.adjustCounter(key, amount);
    }

    public byte[] encodeCounter(long value) {
        return this.view.encodeCounter(value);
    }

    public long decodeCounter(byte[] bytes) {
        return this.view.decodeCounter(bytes);
    }

    public CachingKVDatabase getKVDatabase() {
        return this.kvdb;
    }

    public void setTimeout(long timeout) {
        this.inner.setTimeout(timeout);
    }

    public boolean isReadOnly() {
        return this.inner.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.inner.setReadOnly(readOnly);
    }

    public Future<Void> watchKey(byte[] key) {
        return this.inner.watchKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Writes writes;
        MutableView mutableView = this.view;
        synchronized (mutableView) {
            writes = this.view.getWrites();
            this.view.setReadOnly();
            this.cachingKV.close();
        }
        try {
            this.applyWritesBeforeCommitIfNotReadOnly(writes);
            this.inner.commit();
        }
        finally {
            this.close();
        }
    }

    public void rollback() {
        try {
            this.inner.rollback();
        }
        finally {
            this.close();
        }
    }

    public CloseableKVStore mutableSnapshot() {
        return this.inner.mutableSnapshot();
    }

    protected void applyWritesBeforeCommitIfNotReadOnly(Writes writes) {
        if (!this.inner.isReadOnly()) {
            writes.applyTo((KVStore)this.inner);
        }
    }
}

