/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.sqlite;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.sql.SQLKVDatabase;
import org.jsimpledb.kv.sql.SQLKVTransaction;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;
import org.sqlite.SQLiteErrorCode;
import org.sqlite.SQLiteOpenMode;

public class SQLiteKVDatabase
extends SQLKVDatabase {
    public static final String SQLITE_DRIVER_CLASS_NAME = "org.sqlite.JDBC";
    public static final File MEMORY_FILE = new File(":memory");
    private static final int DEFAULT_LOCK_TIMEOUT = 10;
    private File file;
    private SQLiteConfig config = new SQLiteConfig();
    private boolean exclusiveLocking;
    private List<String> pragmas;

    public SQLiteKVDatabase() {
        this.config.setJournalMode(SQLiteConfig.JournalMode.WAL);
        this.config.setOpenMode(SQLiteOpenMode.READWRITE);
        this.config.setOpenMode(SQLiteOpenMode.CREATE);
        this.config.setOpenMode(SQLiteOpenMode.OPEN_URI);
    }

    public File getDatabaseFile() {
        return this.file;
    }

    public void setDatabaseFile(File file) {
        this.file = file;
    }

    public void setSQLiteConfig(SQLiteConfig config) {
        this.config = config;
    }

    public void setExclusiveLocking(boolean exclusiveLocking) {
        this.exclusiveLocking = exclusiveLocking;
    }

    public void setPragmas(List<String> pragmas) {
        this.pragmas = pragmas;
    }

    public void start() {
        try {
            Class.forName(SQLITE_DRIVER_CLASS_NAME, false, Thread.currentThread().getContextClassLoader());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("can't load SQLite driver class `org.sqlite.JDBC'", e);
        }
        if (this.getDataSource() == null && this.file != null) {
            SQLiteDataSource dataSource = this.config != null ? new SQLiteDataSource(this.config) : new SQLiteDataSource();
            String uri = "jdbc:sqlite:" + this.file.toURI().toString().substring("file:".length());
            this.log.debug("auto-configuring SQLite DataSource using URI `" + uri + "'");
            dataSource.setUrl(uri);
            this.setDataSource((DataSource)dataSource);
        }
        super.start();
        this.log.debug("SQLite database " + (this.file != null ? this.file + " " : "") + "started");
    }

    protected void initializeDatabaseIfNecessary(Connection connection) throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS " + this.quote(this.getTableName()) + "(\n  " + this.quote(this.getKeyColumnName()) + " BLOB\n    CONSTRAINT " + this.quote(this.getKeyColumnName() + "_null") + " NOT NULL\n    CONSTRAINT " + this.quote(this.getKeyColumnName() + "_pkey") + " PRIMARY KEY,\n  " + this.quote(this.getValueColumnName()) + " BLOB\n    CONSTRAINT " + this.quote(this.getValueColumnName() + "_null") + " NOT NULL\n)";
        this.beginTransaction(connection);
        try (Statement statement = connection.createStatement();){
            this.log.debug("auto-creating table `" + this.getTableName() + "' if not already existing:\n{}", (Object)sql);
            statement.execute(sql);
            statement.execute("COMMIT");
        }
        this.log.debug("SQLite database " + (this.file != null ? this.file + " " : "") + "started");
    }

    protected void configureConnection(Connection connection) throws SQLException {
        if (!this.exclusiveLocking && (this.pragmas == null || this.pragmas.isEmpty())) {
            return;
        }
        try (Statement statement = connection.createStatement();){
            if (this.exclusiveLocking) {
                this.log.debug("configuring database connection for exclusive locking");
                statement.execute("PRAGMA locking_mode=EXCLUSIVE");
            }
            if (this.pragmas != null) {
                for (String pragma : this.pragmas) {
                    this.log.debug("configuring database connection with PRAGMA " + pragma);
                    statement.execute("PRAGMA " + pragma);
                }
            }
        }
    }

    public String createPutStatement() {
        return "INSERT OR REPLACE INTO " + this.quote(this.getTableName()) + " (" + this.quote(this.getKeyColumnName()) + ", " + this.quote(this.getValueColumnName()) + ") VALUES (?, ?)";
    }

    public String quote(String name) {
        return "\"" + name + "\"";
    }

    public String limitSingleRow(String sql) {
        return sql + " LIMIT 1";
    }

    public KVTransactionException wrapException(SQLKVTransaction tx, SQLException e) {
        switch (SQLiteErrorCode.getErrorCode((int)e.getErrorCode())) {
            case SQLITE_BUSY: 
            case SQLITE_LOCKED: {
                return new RetryTransactionException((KVTransaction)tx, (Throwable)e);
            }
        }
        return super.wrapException(tx, e);
    }
}

