/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.iq80.leveldb.impl.ReverseIterator;
import org.iq80.leveldb.impl.ReversePeekingIterator;

public final class ReverseIterators {
    private ReverseIterators() {
    }

    public static <T> ListReverseIterator<T> listReverseIterator(ListIterator<T> listIter) {
        return new ListReverseIterator<T>(listIter);
    }

    public static <T> ListReverseIterator<T> listReverseIterator(List<T> list) {
        return ReverseIterators.listReverseIterator(list.listIterator());
    }

    public static <T> ListReverseIterator<T> listReverseIterator(Collection<T> collection) {
        return ReverseIterators.listReverseIterator(Lists.newArrayList(collection));
    }

    public static <T> ReversePeekingIterator<T> reversePeekingIterator(ListIterator<? extends T> listIter) {
        return ReverseIterators.reversePeekingIterator(ReverseIterators.listReverseIterator(listIter));
    }

    public static <T> ReversePeekingIterator<T> reversePeekingIterator(List<? extends T> list) {
        return ReverseIterators.reversePeekingIterator(ReverseIterators.listReverseIterator(list));
    }

    public static <T> ReversePeekingIterator<T> reversePeekingIterator(Collection<? extends T> collection) {
        return ReverseIterators.reversePeekingIterator(ReverseIterators.listReverseIterator(collection));
    }

    public static <T> ReversePeekingIterator<T> reversePeekingIterator(ReverseIterator<? extends T> iterator) {
        if (iterator instanceof ReversePeekingImpl) {
            ReversePeekingImpl rPeeking = (ReversePeekingImpl)iterator;
            return rPeeking;
        }
        return new ReversePeekingImpl<T>(iterator);
    }

    public static <T extends Iterator<?>> Predicate<T> hasNext() {
        return new Predicate<T>(){

            public boolean apply(T iter) {
                return iter.hasNext();
            }
        };
    }

    public static <T extends ReverseIterator<?>> Predicate<T> hasPrev() {
        return new Predicate<T>(){

            public boolean apply(T iter) {
                return iter.hasPrev();
            }
        };
    }

    private static class ReversePeekingImpl<E>
    implements PeekingIterator<E>,
    ReversePeekingIterator<E> {
        private final ReverseIterator<? extends E> rIterator;
        private boolean rHasPeeked;
        private E rPeekedElement;
        private boolean hasPeeked;
        private E peekedElement;

        public ReversePeekingImpl(ReverseIterator<? extends E> iterator) {
            this.rIterator = (ReverseIterator)Preconditions.checkNotNull(iterator);
        }

        @Override
        public boolean hasNext() {
            return this.hasPeeked || this.rIterator.hasNext();
        }

        @Override
        public boolean hasPrev() {
            return this.rHasPeeked || this.rIterator.hasPrev();
        }

        @Override
        public E next() {
            this.hasPeeked = false;
            this.peekedElement = null;
            Object next = this.rIterator.next();
            this.rHasPeeked = true;
            this.rPeekedElement = next;
            return next;
        }

        @Override
        public E prev() {
            this.rHasPeeked = false;
            this.rPeekedElement = null;
            E prev = this.rIterator.prev();
            this.hasPeeked = true;
            this.peekedElement = prev;
            return prev;
        }

        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.rIterator.next();
                this.rIterator.prev();
                this.hasPeeked = true;
            }
            return this.peekedElement;
        }

        @Override
        public E peekPrev() {
            if (!this.rHasPeeked) {
                this.rPeekedElement = this.rIterator.prev();
                this.rIterator.next();
                this.rHasPeeked = true;
            }
            return this.rPeekedElement;
        }

        @Override
        public void remove() {
            Preconditions.checkState((!this.hasPeeked && !this.rHasPeeked ? 1 : 0) != 0, (Object)"Can't remove after peeking at next or previous");
            this.rIterator.remove();
        }
    }

    private static class ListReverseIterator<E>
    implements ReverseIterator<E> {
        private final ListIterator<E> iter;

        public ListReverseIterator(ListIterator<E> listIterator) {
            this.iter = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public E prev() {
            return this.iter.previous();
        }

        @Override
        public boolean hasPrev() {
            return this.iter.hasPrevious();
        }
    }
}

