/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.NoSuchElementException;
import org.iq80.leveldb.impl.ReverseSeekingIterator;
import org.iq80.leveldb.table.BlockEntry;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.VariableLengthQuantity;

public class BlockIterator
implements ReverseSeekingIterator<Slice, Slice> {
    private final SliceInput data;
    private final Slice restartPositions;
    private final int restartCount;
    private int prevPosition;
    private int restartIndex;
    private final Comparator<Slice> comparator;
    private BlockEntry nextEntry;
    private BlockEntry prevEntry;
    private final Deque<CacheEntry> prevCache;
    private int prevCacheRestartIndex;

    public BlockIterator(Slice data, Slice restartPositions, Comparator<Slice> comparator) {
        Preconditions.checkNotNull((Object)data, (Object)"data is null");
        Preconditions.checkNotNull((Object)restartPositions, (Object)"restartPositions is null");
        Preconditions.checkArgument((restartPositions.length() % 4 == 0 ? 1 : 0) != 0, (String)"restartPositions.readableBytes() must be a multiple of %s", (Object[])new Object[]{(byte)4});
        Preconditions.checkNotNull(comparator, (Object)"comparator is null");
        this.data = data.input();
        this.restartPositions = restartPositions.slice();
        this.restartCount = this.restartPositions.length() / 4;
        this.comparator = comparator;
        this.prevCache = new ArrayDeque<CacheEntry>();
        this.prevCacheRestartIndex = -1;
        this.seekToFirst();
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public boolean hasPrev() {
        return this.prevEntry != null || this.currentPosition() > 0;
    }

    public BlockEntry peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextEntry;
    }

    @Override
    public BlockEntry peekPrev() {
        if (this.prevEntry == null && this.currentPosition() > 0) {
            BlockEntry peeked = this.prev();
            this.next();
            this.prevEntry = peeked;
        } else if (this.prevEntry == null) {
            throw new NoSuchElementException();
        }
        return this.prevEntry;
    }

    @Override
    public BlockEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prevEntry = this.nextEntry;
        this.nextEntry = !this.data.isReadable() ? null : this.readEntry(this.data, this.prevEntry);
        this.resetCache();
        return this.prevEntry;
    }

    @Override
    public BlockEntry prev() {
        int original = this.currentPosition();
        if (original == 0) {
            throw new NoSuchElementException();
        }
        int previousRestart = this.getPreviousRestart(this.restartIndex, original);
        if (previousRestart == this.prevCacheRestartIndex && this.prevCache.size() > 0) {
            CacheEntry prevState = this.prevCache.pop();
            this.nextEntry = prevState.entry;
            this.prevPosition = prevState.prevPosition;
            this.data.setPosition(prevState.dataPosition);
            CacheEntry peek = this.prevCache.peek();
            this.prevEntry = peek == null ? null : peek.entry;
        } else {
            this.seekToRestartPosition(previousRestart);
            this.prevCacheRestartIndex = previousRestart;
            this.prevCache.push(new CacheEntry(this.nextEntry, this.prevPosition, this.data.position()));
            while (this.data.position() < original && this.data.isReadable()) {
                this.prevEntry = this.nextEntry;
                this.nextEntry = this.readEntry(this.data, this.prevEntry);
                this.prevCache.push(new CacheEntry(this.nextEntry, this.prevPosition, this.data.position()));
            }
            this.prevCache.pop();
        }
        return this.nextEntry;
    }

    private int getPreviousRestart(int startIndex, int position) {
        while (this.getRestartPoint(startIndex) >= position) {
            if (startIndex == 0) {
                throw new NoSuchElementException();
            }
            --startIndex;
        }
        return startIndex;
    }

    private int currentPosition() {
        if (this.nextEntry != null) {
            return this.prevPosition;
        }
        return this.data.position();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekToFirst() {
        if (this.restartCount > 0) {
            this.seekToRestartPosition(0);
        }
    }

    @Override
    public void seekToLast() {
        if (this.restartCount > 0) {
            this.seekToRestartPosition(Math.max(0, this.restartCount - 1));
            while (this.data.isReadable()) {
                this.next();
            }
        }
    }

    @Override
    public void seekToEnd() {
        if (this.restartCount > 0) {
            this.seekToLast();
            this.next();
        }
    }

    @Override
    public void seek(Slice targetKey) {
        if (this.restartCount == 0) {
            return;
        }
        int left = 0;
        int right = this.restartCount - 1;
        while (left < right) {
            int mid = (left + right + 1) / 2;
            this.seekToRestartPosition(mid);
            if (this.comparator.compare(this.nextEntry.getKey(), targetKey) < 0) {
                left = mid;
                continue;
            }
            right = mid - 1;
        }
        this.seekToRestartPosition(left);
        while (this.nextEntry != null && this.comparator.compare(this.peek().getKey(), targetKey) < 0) {
            this.next();
        }
    }

    private void seekToRestartPosition(int restartPosition) {
        Preconditions.checkPositionIndex((int)restartPosition, (int)this.restartCount, (String)"restartPosition");
        this.data.setPosition(this.getRestartPoint(restartPosition));
        this.nextEntry = null;
        this.prevEntry = null;
        this.resetCache();
        this.restartIndex = restartPosition;
        this.nextEntry = this.readEntry(this.data, null);
    }

    private int getRestartPoint(int index) {
        return this.restartPositions.getInt(index * 4);
    }

    private BlockEntry readEntry(SliceInput data, BlockEntry previousEntry) {
        this.prevPosition = data.position();
        int sharedKeyLength = VariableLengthQuantity.readVariableLengthInt(data);
        int nonSharedKeyLength = VariableLengthQuantity.readVariableLengthInt(data);
        int valueLength = VariableLengthQuantity.readVariableLengthInt(data);
        Slice key = Slices.allocate(sharedKeyLength + nonSharedKeyLength);
        SliceOutput sliceOutput = key.output();
        if (sharedKeyLength > 0) {
            Preconditions.checkState((previousEntry != null ? 1 : 0) != 0, (Object)"Entry has a shared key but no previous entry was provided");
            sliceOutput.writeBytes(previousEntry.getKey(), 0, sharedKeyLength);
        }
        sliceOutput.writeBytes(data, nonSharedKeyLength);
        Slice value = data.readSlice(valueLength);
        return new BlockEntry(key, value);
    }

    private void resetCache() {
        this.prevCache.clear();
        this.prevCacheRestartIndex = -1;
    }

    private static class CacheEntry {
        public final BlockEntry entry;
        public final int prevPosition;
        public final int dataPosition;

        public CacheEntry(BlockEntry entry, int prevPosition, int dataPosition) {
            this.entry = entry;
            this.prevPosition = prevPosition;
            this.dataPosition = dataPosition;
        }
    }
}

