/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.util.List;
import java.util.Map;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.util.AbstractReverseSeekingIterator;
import org.iq80.leveldb.util.InternalIterator;
import org.iq80.leveldb.util.InternalTableIterator;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.TableIterator;

public final class LevelIterator
extends AbstractReverseSeekingIterator<InternalKey, Slice>
implements InternalIterator {
    private final TableCache tableCache;
    private final List<FileMetaData> files;
    private final InternalKeyComparator comparator;
    private InternalTableIterator current;
    private TableIterator.CurrentOrigin currentOrigin = TableIterator.CurrentOrigin.NONE;
    private int index;

    public LevelIterator(TableCache tableCache, List<FileMetaData> files, InternalKeyComparator comparator) {
        this.tableCache = tableCache;
        this.files = files;
        this.comparator = comparator;
    }

    @Override
    protected void seekToFirstInternal() {
        this.index = 0;
        this.current = null;
        this.currentOrigin = TableIterator.CurrentOrigin.NONE;
    }

    @Override
    protected void seekToLastInternal() {
        this.index = this.files.size() - 1;
        this.current = this.openFile(this.index);
        this.currentOrigin = TableIterator.CurrentOrigin.PREV;
        this.current.seekToLastInternal();
    }

    @Override
    public void seekToEndInternal() {
        this.index = this.files.size() - 1;
        this.current = this.openFile(this.index);
        this.currentOrigin = TableIterator.CurrentOrigin.PREV;
        this.current.seekToEnd();
    }

    @Override
    protected void seekInternal(InternalKey targetKey) {
        if (this.files.size() == 0) {
            return;
        }
        int left = 0;
        int right = this.files.size() - 1;
        while (left < right) {
            int mid = (left + right) / 2;
            if (this.comparator.compare(this.files.get(mid).getLargest(), targetKey) < 0) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        this.index = right;
        if (this.index == this.files.size() - 1 && this.comparator.compare(this.files.get(this.index).getLargest(), targetKey) < 0) {
            ++this.index;
        }
        if (this.index < this.files.size()) {
            this.current = this.openNextFile();
            this.current.seek(targetKey);
        } else {
            this.current = null;
            this.currentOrigin = TableIterator.CurrentOrigin.NONE;
        }
    }

    @Override
    protected boolean hasNextInternal() {
        return this.currentHasNext();
    }

    @Override
    protected boolean hasPrevInternal() {
        return this.currentHasPrev();
    }

    @Override
    protected Map.Entry<InternalKey, Slice> getNextElement() {
        return this.currentHasNext() ? this.current.next() : null;
    }

    @Override
    protected Map.Entry<InternalKey, Slice> getPrevElement() {
        return this.currentHasPrev() ? this.current.prev() : null;
    }

    @Override
    protected Map.Entry<InternalKey, Slice> peekInternal() {
        return this.currentHasNext() ? this.current.peek() : null;
    }

    @Override
    protected Map.Entry<InternalKey, Slice> peekPrevInternal() {
        return this.currentHasPrev() ? this.current.peekPrev() : null;
    }

    private boolean currentHasNext() {
        boolean currentHasNext = false;
        while (true) {
            if (this.current != null) {
                currentHasNext = this.current.hasNext();
            }
            if (currentHasNext) break;
            if (this.currentOrigin == TableIterator.CurrentOrigin.PREV) {
                ++this.index;
            }
            if (this.index >= this.files.size()) break;
            this.current = this.openNextFile();
        }
        if (!currentHasNext) {
            this.current = null;
            this.currentOrigin = TableIterator.CurrentOrigin.NONE;
        }
        return currentHasNext;
    }

    private boolean currentHasPrev() {
        boolean currentHasPrev = false;
        while (true) {
            if (this.current != null) {
                currentHasPrev = this.current.hasPrev();
            }
            if (currentHasPrev) break;
            if (this.currentOrigin == TableIterator.CurrentOrigin.NEXT) {
                --this.index;
            }
            if (this.index <= 0) break;
            this.current = this.openPrevFile();
            this.current.seekToEnd();
        }
        if (!currentHasPrev) {
            this.current = null;
            this.currentOrigin = TableIterator.CurrentOrigin.NONE;
        }
        return currentHasPrev;
    }

    private InternalTableIterator openFile(int i) {
        return this.tableCache.newIterator(this.files.get(i));
    }

    private InternalTableIterator openNextFile() {
        this.currentOrigin = TableIterator.CurrentOrigin.NEXT;
        return this.openFile(this.index++);
    }

    private InternalTableIterator openPrevFile() {
        this.currentOrigin = TableIterator.CurrentOrigin.PREV;
        return this.openFile(--this.index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConcatenatingIterator");
        sb.append("{index=").append(this.index);
        sb.append(", files=").append(this.files);
        sb.append(", current=").append(this.current);
        sb.append('}');
        return sb.toString();
    }
}

