/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.util.Map;
import org.iq80.leveldb.table.Block;
import org.iq80.leveldb.table.BlockIterator;
import org.iq80.leveldb.table.Table;
import org.iq80.leveldb.util.AbstractReverseSeekingIterator;
import org.iq80.leveldb.util.Slice;

public final class TableIterator
extends AbstractReverseSeekingIterator<Slice, Slice> {
    private final Table table;
    private final BlockIterator blockIterator;
    private BlockIterator current;
    private CurrentOrigin currentOrigin = CurrentOrigin.NONE;

    public TableIterator(Table table, BlockIterator blockIterator) {
        this.table = table;
        this.blockIterator = blockIterator;
        this.clearCurrent();
    }

    @Override
    protected void seekToFirstInternal() {
        this.blockIterator.seekToFirst();
        this.clearCurrent();
    }

    @Override
    protected void seekToLastInternal() {
        this.blockIterator.seekToEnd();
        this.clearCurrent();
        if (this.currentHasPrev()) {
            this.current.prev();
        }
    }

    @Override
    public void seekToEndInternal() {
        this.blockIterator.seekToEnd();
        this.clearCurrent();
    }

    @Override
    protected void seekInternal(Slice targetKey) {
        this.blockIterator.seek(targetKey);
        if (this.blockIterator.hasNext()) {
            this.current = this.getNextBlock();
            this.current.seek(targetKey);
        } else {
            this.clearCurrent();
        }
    }

    @Override
    protected boolean hasNextInternal() {
        return this.currentHasNext();
    }

    @Override
    protected boolean hasPrevInternal() {
        return this.currentHasPrev();
    }

    @Override
    protected Map.Entry<Slice, Slice> getNextElement() {
        return this.currentHasNext() ? this.current.next() : null;
    }

    @Override
    protected Map.Entry<Slice, Slice> getPrevElement() {
        return this.currentHasPrev() ? this.current.prev() : null;
    }

    @Override
    protected Map.Entry<Slice, Slice> peekInternal() {
        return this.currentHasNext() ? this.current.peek() : null;
    }

    @Override
    protected Map.Entry<Slice, Slice> peekPrevInternal() {
        return this.currentHasPrev() ? this.current.peekPrev() : null;
    }

    private boolean currentHasNext() {
        boolean currentHasNext = false;
        while (true) {
            if (this.current != null) {
                currentHasNext = this.current.hasNext();
            }
            if (currentHasNext) break;
            if (this.currentOrigin == CurrentOrigin.PREV) {
                this.blockIterator.next();
            }
            if (!this.blockIterator.hasNext()) break;
            this.current = this.getNextBlock();
        }
        if (!currentHasNext) {
            this.clearCurrent();
        }
        return currentHasNext;
    }

    private boolean currentHasPrev() {
        boolean currentHasPrev = false;
        while (true) {
            if (this.current != null) {
                currentHasPrev = this.current.hasPrev();
            }
            if (currentHasPrev) break;
            if (this.currentOrigin == CurrentOrigin.NEXT) {
                this.blockIterator.prev();
            }
            if (!this.blockIterator.hasPrev()) break;
            this.current = this.getPrevBlock();
            this.current.seekToEnd();
        }
        if (!currentHasPrev) {
            this.clearCurrent();
        }
        return currentHasPrev;
    }

    private BlockIterator getNextBlock() {
        Slice blockHandle = this.blockIterator.next().getValue();
        Block dataBlock = this.table.openBlock(blockHandle);
        this.currentOrigin = CurrentOrigin.NEXT;
        return dataBlock.iterator();
    }

    private BlockIterator getPrevBlock() {
        Slice blockHandle = this.blockIterator.prev().getValue();
        Block dataBlock = this.table.openBlock(blockHandle);
        this.currentOrigin = CurrentOrigin.PREV;
        return dataBlock.iterator();
    }

    private void clearCurrent() {
        this.current = null;
        this.currentOrigin = CurrentOrigin.NONE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConcatenatingIterator");
        sb.append("{blockIterator=").append(this.blockIterator);
        sb.append(", current=").append(this.current);
        sb.append('}');
        return sb.toString();
    }

    protected static enum CurrentOrigin {
        PREV,
        NEXT,
        NONE;

    }
}

