/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedMap;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.PropertyExtractor;
import org.dellroad.stuff.vaadin7.ProvidesPropertyScanner;
import org.dellroad.stuff.vaadin7.SimpleItem;
import org.dellroad.stuff.vaadin7.SimpleKeyedContainer;
import org.jsimpledb.CopyState;
import org.jsimpledb.JCollectionField;
import org.jsimpledb.JCounterField;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JFieldSwitchAdapter;
import org.jsimpledb.JMapField;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.UnknownFieldException;
import org.jsimpledb.core.util.ObjIdSet;
import org.jsimpledb.vaadin.ReferenceMethodInfoCache;
import org.jsimpledb.vaadin.SizedLabel;
import org.jsimpledb.vaadin.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JObjectContainer
extends SimpleKeyedContainer<ObjId, JObject> {
    public static final String REFERENCE_LABEL_PROPERTY = "$label";
    public static final String OBJECT_ID_PROPERTY = "$objId";
    public static final String TYPE_PROPERTY = "$type";
    public static final String VERSION_PROPERTY = "$version";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final JSimpleDB jdb;
    private final ObjIdPropertyDef objIdPropertyDef = new ObjIdPropertyDef();
    private final ObjTypePropertyDef objTypePropertyDef = new ObjTypePropertyDef();
    private final ObjVersionPropertyDef objVersionPropertyDef = new ObjVersionPropertyDef();
    private final RefLabelPropertyDef refLabelPropertyDef = new RefLabelPropertyDef();
    private Class<?> type;
    private ProvidesPropertyScanner<?> propertyScanner;
    private List<String> orderedPropertyNames;

    protected JObjectContainer(JSimpleDB jdb, Class<?> type) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        this.jdb = jdb;
        this.setType(type);
        this.setPropertyExtractor((PropertyExtractor)this);
    }

    public Class<?> getType() {
        return this.type;
    }

    public <T> void setType(Class<T> type) {
        this.type = type;
        this.propertyScanner = this.type != null ? new ProvidesPropertyScanner(type) : null;
        ArrayList propertyDefs = new ArrayList(this.buildPropertyDefs());
        this.orderedPropertyNames = Collections.unmodifiableList(Lists.transform(propertyDefs, PropertyDef::getName));
        this.setProperties(propertyDefs);
        this.fireContainerPropertySetChange();
    }

    public List<String> getOrderedPropertyNames() {
        return this.orderedPropertyNames;
    }

    public ObjId getKeyFor(JObject jobj) {
        return jobj.getObjId();
    }

    public void load(Iterable<? extends JObject> jobjs) {
        this.load(jobjs.iterator());
    }

    public void load(Iterator<? extends JObject> jobjs) {
        if (this.type != null) {
            jobjs = Iterators.filter(jobjs, this.type::isInstance);
        }
        ObjIdSet seenIds = new ObjIdSet();
        jobjs = Iterators.filter(jobjs, jobj -> jobj != null && seenIds.add(jobj.getObjId()));
        super.load((Iterator)jobjs);
    }

    public void updateItem(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        SimpleItem item = (SimpleItem)this.getItem(jobj.getObjId());
        if (item != null) {
            jobj.copyTo(((JObject)item.getObject()).getTransaction(), new CopyState(), new String[0]);
            item.fireValueChange();
        }
    }

    protected void doInTransaction(Runnable action) {
        JTransaction jtx = this.jdb.createTransaction(false, ValidationMode.DISABLED);
        jtx.getTransaction().setReadOnly(true);
        try {
            jtx.performAction(action);
        }
        finally {
            jtx.commit();
        }
    }

    private Collection<PropertyDef<?>> buildPropertyDefs() {
        PropertyDefHolder pdefs = new PropertyDefHolder();
        pdefs.setPropertyDef(this.refLabelPropertyDef);
        pdefs.setPropertyDef(this.objIdPropertyDef);
        pdefs.setPropertyDef(this.objTypePropertyDef);
        pdefs.setPropertyDef(this.objVersionPropertyDef);
        SortedMap<Integer, JField> jfields = Util.getCommonJFields(this.jdb.getJClasses(this.type));
        if (jfields != null) {
            for (JField jfield : jfields.values()) {
                pdefs.setPropertyDef(new ObjFieldPropertyDef(jfield.getStorageId(), jfield.getName()));
            }
        }
        if (this.propertyScanner != null) {
            for (PropertyDef propertyDef : this.propertyScanner.getPropertyDefs()) {
                pdefs.setPropertyDef(propertyDef);
            }
        }
        return pdefs.values();
    }

    public <V> V getPropertyValue(JObject jobj, PropertyDef<V> propertyDef) {
        if (propertyDef instanceof ObjPropertyDef) {
            return (V)((ObjPropertyDef)propertyDef).extract(jobj);
        }
        if (this.propertyScanner == null) {
            throw new IllegalArgumentException("unknown property: " + propertyDef.getName());
        }
        return JObjectContainer.extractProperty(this.propertyScanner.getPropertyExtractor(), propertyDef, jobj);
    }

    private static <V> V extractProperty(PropertyExtractor<?> propertyExtractor, PropertyDef<V> propertyDef, JObject jobj) {
        try {
            return (V)propertyExtractor.getPropertyValue((Object)jobj, propertyDef);
        }
        catch (DeletedObjectException e) {
            try {
                return (V)propertyDef.getType().cast((Object)new SizedLabel("<i>Unavailable</i>", ContentMode.HTML));
            }
            catch (ClassCastException e2) {
                try {
                    return (V)propertyDef.getType().cast("(Unavailable)");
                }
                catch (ClassCastException e3) {
                    return null;
                }
            }
        }
    }

    private static class PropertyDefHolder
    extends LinkedHashMap<String, PropertyDef<?>> {
        private PropertyDefHolder() {
        }

        public void setPropertyDef(PropertyDef<?> propertyDef) {
            this.put(propertyDef.getName(), propertyDef);
        }
    }

    public class ObjFieldPropertyDef
    extends ObjPropertyDef<Component> {
        private static final int MAX_ITEMS = 3;
        private final int storageId;

        public ObjFieldPropertyDef(int storageId, String name) {
            super(name, Component.class);
            this.storageId = storageId;
        }

        @Override
        public Component extract(final JObject jobj) {
            JField jfield = JObjectContainer.this.jdb.getJClass(jobj.getObjId()).getJField(this.storageId, JField.class);
            try {
                return (Component)jfield.visit((JFieldSwitch)new JFieldSwitchAdapter<Component>(){

                    public Component caseJSimpleField(JSimpleField field) {
                        return ObjFieldPropertyDef.this.handleValue(field.getValue(jobj));
                    }

                    public Component caseJCounterField(JCounterField field) {
                        return ObjFieldPropertyDef.this.handleValue(field.getValue(jobj).get());
                    }

                    protected Component caseJCollectionField(JCollectionField field) {
                        return ObjFieldPropertyDef.this.handleCollectionField(field.getValue(jobj));
                    }

                    public Component caseJMapField(JMapField field) {
                        return ObjFieldPropertyDef.this.handleMultiple(Iterables.transform(field.getValue(jobj).entrySet(), entry -> {
                            HorizontalLayout layout = new HorizontalLayout();
                            layout.setMargin(false);
                            layout.setSpacing(false);
                            layout.addComponent(ObjFieldPropertyDef.this.handleValue(entry.getKey()));
                            layout.addComponent((Component)new SizedLabel(" \u21d2 "));
                            layout.addComponent(ObjFieldPropertyDef.this.handleValue(entry.getValue()));
                            return layout;
                        }));
                    }
                });
            }
            catch (UnknownFieldException e) {
                return new SizedLabel("<i>NA</i>", ContentMode.HTML);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ObjFieldPropertyDef that = (ObjFieldPropertyDef)((Object)obj);
            return this.storageId == that.storageId;
        }

        public int hashCode() {
            return super.hashCode() ^ this.storageId;
        }

        private Component handleCollectionField(Collection<?> col) {
            return this.handleMultiple(Iterables.transform(col, this::handleValue));
        }

        private Component handleMultiple(Iterable<Component> components) {
            HorizontalLayout layout = new HorizontalLayout();
            layout.setMargin(false);
            layout.setSpacing(false);
            int count = 0;
            for (Component component : components) {
                if (count >= 3) {
                    layout.addComponent((Component)new SizedLabel("..."));
                    break;
                }
                if (count > 0) {
                    layout.addComponent((Component)new SizedLabel(",&#160;", ContentMode.HTML));
                }
                layout.addComponent(component);
                ++count;
            }
            return layout;
        }

        private <T> Component handleValue(Object value) {
            if (value == null) {
                return new SizedLabel("<i>Null</i>", ContentMode.HTML);
            }
            if (value instanceof JObject) {
                return new RefLabelPropertyDef().extract((JObject)value);
            }
            return new SizedLabel(String.valueOf(value));
        }
    }

    public static class RefLabelPropertyDef
    extends ObjPropertyDef<Component> {
        public RefLabelPropertyDef() {
            super(JObjectContainer.REFERENCE_LABEL_PROPERTY, Component.class);
        }

        @Override
        public Component extract(JObject jobj) {
            ReferenceMethodInfoCache.PropertyInfo<?> propertyInfo = ReferenceMethodInfoCache.getInstance().getReferenceMethodInfo(jobj.getClass());
            if (propertyInfo == ReferenceMethodInfoCache.NOT_FOUND) {
                return new ObjIdPropertyDef().extract(jobj);
            }
            Object value = JObjectContainer.extractProperty(propertyInfo.getPropertyExtractor(), propertyInfo.getPropertyDef(), jobj);
            if (value instanceof Component) {
                return (Component)value;
            }
            return new SizedLabel(String.valueOf(value));
        }
    }

    public static class ObjVersionPropertyDef
    extends ObjPropertyDef<SizedLabel> {
        public ObjVersionPropertyDef() {
            super(JObjectContainer.VERSION_PROPERTY, SizedLabel.class);
        }

        @Override
        public SizedLabel extract(JObject jobj) {
            return new SizedLabel("" + jobj.getSchemaVersion());
        }
    }

    public static class ObjTypePropertyDef
    extends ObjPropertyDef<SizedLabel> {
        public ObjTypePropertyDef() {
            super(JObjectContainer.TYPE_PROPERTY, SizedLabel.class);
        }

        @Override
        public SizedLabel extract(JObject jobj) {
            return new SizedLabel(jobj.getTransaction().getTransaction().getSchemas().getVersion(jobj.getSchemaVersion()).getObjType(jobj.getObjId().getStorageId()).getName());
        }
    }

    public static class ObjIdPropertyDef
    extends ObjPropertyDef<SizedLabel> {
        public ObjIdPropertyDef() {
            super(JObjectContainer.OBJECT_ID_PROPERTY, SizedLabel.class);
        }

        @Override
        public SizedLabel extract(JObject jobj) {
            return new SizedLabel("<code>" + jobj.getObjId() + "</code>", ContentMode.HTML);
        }
    }

    public static abstract class ObjPropertyDef<T>
    extends PropertyDef<T> {
        protected ObjPropertyDef(String name, Class<T> type) {
            super(name, type);
        }

        public abstract T extract(JObject var1);
    }
}

