/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.vaadin.data.Property;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import java.io.Serializable;
import org.dellroad.stuff.vaadin7.FieldLayout;
import org.jsimpledb.vaadin.SmallButton;

public class NullableField<T>
extends FieldLayout<T> {
    private final SmallButton nullButton = new SmallButton("Null", (Button.ClickListener & Serializable)e -> this.field.setValue(null));

    public NullableField(Field<T> field) {
        super(field);
        this.setMargin(false);
        this.setSpacing(true);
        this.addComponent((Component)this.field);
        this.addComponent((Component)this.nullButton);
        this.setComponentAlignment((Component)this.nullButton, Alignment.MIDDLE_LEFT);
        this.field.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.updateDisplay());
        if (this.field instanceof Property.ReadOnlyStatusChangeNotifier) {
            Property.ReadOnlyStatusChangeNotifier notifier = (Property.ReadOnlyStatusChangeNotifier)field;
            notifier.addReadOnlyStatusChangeListener((Property.ReadOnlyStatusChangeListener & Serializable)e -> this.updateDisplay());
        }
    }

    public void attach() {
        super.attach();
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.nullButton.setEnabled(this.field.getValue() != null && !this.field.isReadOnly());
    }
}

