/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.jsimpledb.CopyState;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.SnapshotJTransaction;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.vaadin.ReloadableJObjectContainer;

public abstract class QueryJObjectContainer
extends ReloadableJObjectContainer {
    protected QueryJObjectContainer(JSimpleDB jdb, Class<?> type) {
        super(jdb, type);
    }

    @Override
    public void reload() {
        this.doInTransaction(this::reloadInTransaction);
    }

    private void reloadInTransaction() {
        Iterator jobjs = this.queryForObjects();
        SnapshotJTransaction snapshotTx = JTransaction.getCurrent().createSnapshotTransaction(ValidationMode.DISABLED);
        CopyState copyState = new CopyState();
        jobjs = Iterators.transform(jobjs, jobj -> this.copyWithRelated((JObject)jobj, (JTransaction)snapshotTx, copyState));
        this.load(jobjs);
    }

    public JObject copyWithRelated(JObject target, JTransaction dest, CopyState copyState) {
        if (target == null) {
            return null;
        }
        JTransaction jtx = target.getTransaction();
        JObject copy = target.copyTo(dest, copyState, new String[0]);
        Iterable<? extends JObject> relatedObjects = this.getRelatedObjects(target);
        if (relatedObjects != null) {
            jtx.copyTo(dest, copyState, relatedObjects);
        }
        return copy;
    }

    protected Iterable<? extends JObject> getRelatedObjects(JObject jobj) {
        return this.jdb.getReferencedObjects(jobj);
    }

    protected abstract Iterator<? extends JObject> queryForObjects();
}

