/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.PropertyExtractor;
import org.dellroad.stuff.vaadin7.ProvidesPropertyScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReferenceMethodInfoCache {
    static final PropertyInfo<Void> NOT_FOUND = new PropertyInfo(null, null);
    private static final ReferenceMethodInfoCache INSTANCE = new ReferenceMethodInfoCache();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LoadingCache<Class<?>, PropertyInfo<?>> cache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, PropertyInfo<?>>(){

        public PropertyInfo<?> load(Class<?> type) {
            return ReferenceMethodInfoCache.this.findReferenceLablePropertyInfo(type);
        }
    });

    private ReferenceMethodInfoCache() {
    }

    public static ReferenceMethodInfoCache getInstance() {
        return INSTANCE;
    }

    public <T> PropertyInfo<T> getReferenceMethodInfo(Class<T> type) {
        return (PropertyInfo)this.cache.getUnchecked(type);
    }

    private <T> PropertyInfo<T> findReferenceLablePropertyInfo(Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        ProvidesPropertyScanner scanner = new ProvidesPropertyScanner(type);
        PropertyDef propertyDef = (PropertyDef)Iterables.find((Iterable)scanner.getPropertyDefs(), pdef -> pdef.getName().equals("$label"), null);
        return propertyDef != null ? new PropertyInfo((PropertyDef<?>)propertyDef, scanner.getPropertyExtractor()) : NOT_FOUND;
    }

    public static class PropertyInfo<T> {
        private final PropertyDef<?> propertyDef;
        private final PropertyExtractor<T> propertyExtractor;

        PropertyInfo(PropertyDef<?> propertyDef, PropertyExtractor<T> propertyExtractor) {
            this.propertyDef = propertyDef;
            this.propertyExtractor = propertyExtractor;
        }

        public PropertyDef<?> getPropertyDef() {
            return this.propertyDef;
        }

        public PropertyExtractor<T> getPropertyExtractor() {
            return this.propertyExtractor;
        }
    }
}

