/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import com.vaadin.server.VaadinSession;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.vaadin.JObjectContainer;

public abstract class ReloadableJObjectContainer
extends JObjectContainer {
    private VaadinSession vaadinSession;

    protected ReloadableJObjectContainer(JSimpleDB jdb, Class<?> type) {
        super(jdb, type);
    }

    public void connect() {
        super.connect();
        this.vaadinSession = VaadinSession.getCurrent();
        this.reload();
    }

    public void disconnect() {
        super.disconnect();
        this.vaadinSession = null;
    }

    public abstract void reload();

    public void reloadAfterCommit() {
        JTransaction.getCurrent().getTransaction().addCallback((Transaction.Callback)new Transaction.CallbackAdapter(){

            public void afterCommit() {
                if (ReloadableJObjectContainer.this.vaadinSession == null) {
                    return;
                }
                ReloadableJObjectContainer.this.vaadinSession.access(() -> {
                    if (ReloadableJObjectContainer.this.vaadinSession != null) {
                        ReloadableJObjectContainer.this.reload();
                    }
                });
            }
        });
    }
}

