/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin;

import java.util.Iterator;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.SnapshotJTransaction;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.vaadin.ReloadableJObjectContainer;

public abstract class SnapshotJObjectContainer
extends ReloadableJObjectContainer {
    private CloseableKVStore kvstore;

    protected SnapshotJObjectContainer(JSimpleDB jdb, Class<?> type) {
        super(jdb, type);
    }

    @Override
    public void disconnect() {
        super.disconnect();
        if (this.kvstore != null) {
            this.kvstore.close();
            this.kvstore = null;
        }
    }

    @Override
    public void reload() {
        CloseableKVStore[] snapshotHolder = new CloseableKVStore[1];
        this.doInTransaction(() -> {
            JTransaction jtx = JTransaction.getCurrent();
            final CloseableKVStore snapshot = jtx.getTransaction().getKVTransaction().mutableSnapshot();
            jtx.getTransaction().addCallback((Transaction.Callback)new Transaction.CallbackAdapter(){

                public void afterCompletion(boolean committed) {
                    if (!committed) {
                        snapshot.close();
                    }
                }
            });
            snapshotHolder[0] = snapshot;
        });
        if (this.kvstore != null) {
            this.kvstore.close();
            this.kvstore = null;
        }
        this.kvstore = snapshotHolder[0];
        SnapshotJTransaction snapshotTx = this.jdb.createSnapshotTransaction((KVStore)this.kvstore, false, ValidationMode.MANUAL);
        snapshotTx.performAction(() -> this.load(this.iterateObjects()));
    }

    protected abstract Iterator<? extends JObject> iterateObjects();
}

